/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.components.columns;

import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponentPart;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.AbstractLayoutEditorTest;

public class ComponentColumnTest
extends AbstractLayoutEditorTest {
    @Test
    public void assertThereIsNoGWTDepInComponentColumn() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
    }

    @Test
    public void emptyPartsWontBreakTest() throws Exception {
        LayoutTemplate layout = this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayout.txt");
        List parts = ((LayoutComponent)((LayoutColumn)((LayoutRow)layout.getRows().get(0)).getLayoutColumns().get(0)).getLayoutComponents().get(0)).getParts();
        Assert.assertTrue((boolean)parts.isEmpty());
    }

    @Test
    public void partsLoadingTest() throws Exception {
        LayoutTemplate layout = this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayoutWithParts.txt");
        List parts = ((LayoutComponent)((LayoutColumn)((LayoutRow)layout.getRows().get(0)).getLayoutColumns().get(0)).getLayoutComponents().get(0)).getParts();
        Assert.assertEquals((long)2L, (long)parts.size());
        Optional<LayoutComponentPart> part1Op = parts.stream().filter(p -> p.getPartId().equals("PART1")).findFirst();
        Assert.assertTrue((boolean)part1Op.isPresent());
        LayoutComponentPart part1 = part1Op.get();
        Assert.assertTrue((boolean)part1.getCssProperties().containsKey("PROP1"));
        Assert.assertEquals((Object)"PROP1_VAL", part1.getCssProperties().get("PROP1"));
        part1.clearCssProperties();
        Assert.assertTrue((boolean)part1.getCssProperties().isEmpty());
        part1.addCssProperty("NEW_PROP", "NEW_VALUE");
        Assert.assertEquals((Object)"NEW_VALUE", part1.getCssProperties().get("NEW_PROP"));
    }
}

