/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client;

import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentGroup;
import org.uberfire.ext.layout.editor.client.widgets.LayoutComponentPalettePresenter;
import org.uberfire.ext.layout.editor.client.widgets.LayoutDragComponentGroupPresenter;

@RunWith(value=MockitoJUnitRunner.class)
public class LayoutComponentPalettePresenterTest {
    public static final String DRAGGABLE_GROUP_NAME = "Draggable group name";
    public static final String DRAGGABLE_COMPONENT_NAME = "Draggable component name";
    @Mock
    private LayoutComponentPalettePresenter.View view;
    @Mock
    private LayoutDragComponentGroupPresenter.View dragComponentGroupView;
    private LayoutDragComponentGroupPresenter dragComponentGroupPresenter;
    private LayoutComponentPalettePresenter presenter;

    @Before
    public void initialize() {
        ManagedInstance instance = (ManagedInstance)Mockito.mock(ManagedInstance.class);
        this.dragComponentGroupPresenter = (LayoutDragComponentGroupPresenter)Mockito.spy((Object)new LayoutDragComponentGroupPresenter(this.dragComponentGroupView));
        Mockito.when((Object)instance.get()).thenReturn((Object)this.dragComponentGroupPresenter);
        this.presenter = new LayoutComponentPalettePresenter(this.view, instance);
    }

    @Test
    public void testInitialization() {
        ((LayoutComponentPalettePresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testAddDraggableGroups() {
        LayoutDragComponentGroup dragGroup = new LayoutDragComponentGroup(DRAGGABLE_GROUP_NAME, true);
        this.presenter.addDraggableGroup(dragGroup);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).init(dragGroup);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).getView();
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setExpanded(true);
        ((LayoutComponentPalettePresenter.View)Mockito.verify((Object)this.view)).addDraggableComponentGroup((UberElement)Matchers.any());
        Assert.assertEquals((long)1L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNotNull(this.presenter.getLayoutDragComponentGroups().get(DRAGGABLE_GROUP_NAME));
        LayoutDragComponent dragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.presenter.addDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME, dragComponent);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).addComponent(DRAGGABLE_COMPONENT_NAME, dragComponent);
        this.presenter.removeDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).removeComponent(DRAGGABLE_COMPONENT_NAME);
    }

    @Test
    public void testAddAndRemoveDraggableGroups() {
        this.testAddDraggableGroups();
        this.presenter.removeDraggableGroup(DRAGGABLE_GROUP_NAME);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)2))).getView();
        ((LayoutComponentPalettePresenter.View)Mockito.verify((Object)this.view)).removeDraggableComponentGroup((UberElement)Matchers.any());
        Assert.assertEquals((long)0L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNull(this.presenter.getLayoutDragComponentGroups().get(DRAGGABLE_GROUP_NAME));
    }

    @Test
    public void testClearPalette() {
        this.testAddDraggableGroups();
        this.presenter.clear();
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)2))).getView();
        ((LayoutComponentPalettePresenter.View)Mockito.verify((Object)this.view)).removeDraggableComponentGroup((UberElement)Matchers.any());
        Assert.assertEquals((long)0L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNull(this.presenter.getLayoutDragComponentGroups().get(DRAGGABLE_GROUP_NAME));
    }

    @Test
    public void testHasDraggableGroup() {
        boolean result = this.presenter.hasDraggableGroup(DRAGGABLE_GROUP_NAME);
        Assert.assertFalse((boolean)result);
        this.testAddDraggableGroups();
        result = this.presenter.hasDraggableGroup(DRAGGABLE_GROUP_NAME);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testHasDraggableComponent() {
        boolean result = this.presenter.hasDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        Assert.assertFalse((boolean)result);
        LayoutDragComponentGroup dragGroup = new LayoutDragComponentGroup(DRAGGABLE_GROUP_NAME);
        this.presenter.addDraggableGroup(dragGroup);
        result = this.presenter.hasDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        Assert.assertFalse((boolean)result);
        LayoutDragComponent dragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.presenter.addDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME, dragComponent);
        Mockito.when((Object)this.dragComponentGroupPresenter.hasComponent(DRAGGABLE_COMPONENT_NAME)).thenReturn((Object)true);
        result = this.presenter.hasDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testRemoveComponent() {
        LayoutDragComponentGroup dragGroup = new LayoutDragComponentGroup(DRAGGABLE_GROUP_NAME);
        LayoutDragComponent dragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.presenter.addDraggableGroup(dragGroup);
        this.presenter.addDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME, dragComponent);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView, (VerificationMode)Mockito.never())).setComponentVisible(Mockito.anyString(), Mockito.anyBoolean());
        Mockito.reset((Object[])new LayoutDragComponentGroupPresenter.View[]{this.dragComponentGroupView});
        Mockito.when((Object)this.dragComponentGroupView.hasComponent(DRAGGABLE_COMPONENT_NAME)).thenReturn((Object)true);
        this.presenter.addDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME, dragComponent);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView, (VerificationMode)Mockito.never())).addComponent(Mockito.anyString(), (LayoutDragComponent)Matchers.any());
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setComponentVisible(DRAGGABLE_COMPONENT_NAME, true);
        this.presenter.removeDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setComponentVisible(DRAGGABLE_COMPONENT_NAME, false);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView, (VerificationMode)Mockito.never())).removeComponent(DRAGGABLE_COMPONENT_NAME);
    }
}

