/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.components.container;

import java.util.function.Supplier;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.AbstractLayoutEditorTest;
import org.uberfire.ext.layout.editor.client.api.ComponentDropEvent;
import org.uberfire.ext.layout.editor.client.api.ComponentRemovedEvent;
import org.uberfire.ext.layout.editor.client.components.columns.Column;
import org.uberfire.ext.layout.editor.client.components.columns.ComponentColumn;
import org.uberfire.ext.layout.editor.client.components.container.Container;
import org.uberfire.ext.layout.editor.client.components.rows.Row;
import org.uberfire.ext.layout.editor.client.components.rows.RowDnDEvent;
import org.uberfire.ext.layout.editor.client.components.rows.RowDrop;
import org.uberfire.ext.layout.editor.client.infra.RowResizeEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.ParameterizedCommand;

public class ContainerTest
extends AbstractLayoutEditorTest {
    @Test
    public void assertEmptyContainerHasEmptyDropRow() {
        this.container.loadEmptyLayout("layout", LayoutTemplate.Style.FLUID, "", "");
        Assert.assertTrue((boolean)this.container.getRows().isEmpty());
        Assert.assertNotNull((Object)this.container.getEmptyDropRow());
        ((Container.View)Mockito.verify((Object)this.view)).addEmptyRow(this.emptyDropRow.getView());
    }

    @Test
    public void createFirstRowFluid() {
        this.container.loadEmptyLayout("layout", LayoutTemplate.Style.FLUID, "", "");
        Util.assertEquals((Object)0, (Object)this.getRowsSizeFromContainer());
        Assert.assertNotNull((Object)this.container.getEmptyDropRow());
        ((Container.View)Mockito.verify((Object)this.view)).addEmptyRow(this.emptyDropRow.getView());
        this.container.createEmptyDropCommand().execute((Object)new RowDrop(new LayoutComponent("dragType"), this.emptyDropRow.getId(), RowDrop.Orientation.BEFORE));
        Util.assertEquals((Object)1, (Object)this.getRowsSizeFromContainer());
        ((EventSourceMock)Mockito.verify((Object)this.componentDropEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ComponentDropEvent.class));
    }

    @Test
    public void createRowsPage() {
        this.container.loadEmptyLayout("layout", LayoutTemplate.Style.PAGE, "", "");
        Util.assertEquals((Object)0, (Object)this.getRowsSizeFromContainer());
        Assert.assertNotNull((Object)this.container.getEmptyDropRow());
        ((Container.View)Mockito.verify((Object)this.view)).addEmptyRow(this.emptyDropRow.getView());
        this.container.createEmptyDropCommand().execute((Object)new RowDrop(new LayoutComponent("dragType"), this.emptyDropRow.getId(), RowDrop.Orientation.BEFORE));
        Util.assertEquals((Object)1, (Object)this.getRowsSizeFromContainer());
        Util.assertEquals((Object)Row.ROW_DEFAULT_HEIGHT, (Object)this.getRowByIndex(0).getHeight());
        ((EventSourceMock)Mockito.verify((Object)this.componentDropEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ComponentDropEvent.class));
        Row row0 = this.getRowByIndex(0);
        row0.drop("dragType", RowDrop.Orientation.AFTER);
        Util.assertEquals((Object)(Row.ROW_DEFAULT_HEIGHT / 2), (Object)this.getRowByIndex(0).getHeight());
        Util.assertEquals((Object)(Row.ROW_DEFAULT_HEIGHT / 2), (Object)this.getRowByIndex(1).getHeight());
        this.container.resizeRows(new RowResizeEvent(row0.getId()).down());
        Util.assertEquals((Object)(Row.ROW_DEFAULT_HEIGHT / 2 + 1), (Object)this.getRowByIndex(0).getHeight());
        Util.assertEquals((Object)(Row.ROW_DEFAULT_HEIGHT / 2 - 1), (Object)this.getRowByIndex(1).getHeight());
        ComponentColumn col = (ComponentColumn)this.getColumnByIndex(this.getRowByIndex(1), 0);
        col.remove();
        Util.assertEquals((Object)Row.ROW_DEFAULT_HEIGHT, (Object)this.getRowByIndex(0).getHeight());
    }

    @Test
    public void loadEmptyTemplateClearEmptyRow() throws Exception {
        Mockito.reset((Object[])new Container.View[]{this.container.getView()});
        LayoutTemplate layoutTemplate = new LayoutTemplate("layout");
        this.container.load(layoutTemplate, "title", "subtitle");
        Util.assertEquals((Object)this.container.getLayoutName(), (Object)"layout");
        Util.assertEquals((Object)this.container.getRows().size(), (Object)0);
        Assert.assertNotNull((Object)this.container.getEmptyDropRow());
        ((Container.View)Mockito.verify((Object)this.container.getView())).clear();
        ((Container.View)Mockito.verify((Object)this.container.getView())).addEmptyRow(this.container.getEmptyDropRow().getView());
        Mockito.reset((Object[])new Container.View[]{this.container.getView()});
        this.container.load(layoutTemplate, "", "");
        Util.assertEquals((Object)this.container.getRows().size(), (Object)0);
        Assert.assertNotNull((Object)this.container.getEmptyDropRow());
        ((Container.View)Mockito.verify((Object)this.container.getView())).clear();
        ((Container.View)Mockito.verify((Object)this.container.getView())).addEmptyRow(this.container.getEmptyDropRow().getView());
    }

    @Test
    public void loadEmptyLayoutClearEmptyRow() throws Exception {
        Mockito.reset((Object[])new Container.View[]{this.container.getView()});
        this.container.loadEmptyLayout("layout", LayoutTemplate.Style.FLUID, "title", "subtitle");
        Util.assertEquals((Object)this.container.getLayoutName(), (Object)"layout");
        Util.assertEquals((Object)this.container.getRows().size(), (Object)0);
        Assert.assertNotNull((Object)this.container.getEmptyDropRow());
        ((Container.View)Mockito.verify((Object)this.container.getView())).clear();
        ((Container.View)Mockito.verify((Object)this.container.getView())).addEmptyRow(this.container.getEmptyDropRow().getView());
        Mockito.reset((Object[])new Container.View[]{this.container.getView()});
        this.container.loadEmptyLayout("layout", LayoutTemplate.Style.FLUID, "title", "subtitle");
        Util.assertEquals((Object)this.container.getRows().size(), (Object)0);
        Assert.assertNotNull((Object)this.container.getEmptyDropRow());
        ((Container.View)Mockito.verify((Object)this.container.getView())).clear();
        ((Container.View)Mockito.verify((Object)this.container.getView())).addEmptyRow(this.container.getEmptyDropRow().getView());
    }

    @Test
    public void loadNonEmptyTemplateClearExistingRows() throws Exception {
        LayoutTemplate layoutTemplate = this.getLayoutFromFileTemplate("org/uberfire/ext/layout/editor/client/sampleFullFluidLayout.txt");
        this.container.load(layoutTemplate, "title", "subtitle");
        Util.assertEquals((Object)this.container.getRows().size(), (Object)4);
        this.container.load(layoutTemplate, "", "");
        Util.assertEquals((Object)this.container.getRows().size(), (Object)4);
    }

    @Test
    public void loadAndExportFluidLayout() throws Exception {
        LayoutTemplate expected = this.loadLayout("org/uberfire/ext/layout/editor/client/sampleFullFluidLayout.txt");
        LayoutTemplate actual = this.container.toLayoutTemplate();
        Util.assertEquals((Object)expected, (Object)actual);
        Util.assertEquals((Object)this.convertLayoutToString(expected), (Object)this.convertLayoutToString(actual));
    }

    @Test
    public void loadAndExportPageLayout() throws Exception {
        LayoutTemplate expected = this.loadLayout("org/uberfire/ext/layout/editor/client/sampleFullPageLayout.txt");
        LayoutTemplate actual = this.container.toLayoutTemplate();
        Util.assertEquals((Object)expected, (Object)actual);
        Util.assertEquals((Object)this.convertLayoutToString(expected), (Object)this.convertLayoutToString(actual));
    }

    @Test
    public void dropBeforeComponentShouldCreateANewRow() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayout.txt");
        Row dropRow = this.getRowByIndex(0);
        RowDrop dropNewComponentOnFirstRow = new RowDrop(new LayoutComponent("dragType"), dropRow.getId(), RowDrop.Orientation.BEFORE);
        dropNewComponentOnFirstRow.newComponent();
        this.container.createRowDropCommand().execute((Object)dropNewComponentOnFirstRow);
        Util.assertEquals((Object)2, (Object)this.getRowsSizeFromContainer());
        Column droppedColumn = this.getColumnByIndex(this.getRowByIndex(0), 0);
        Util.assertEquals((Object)"dragType", (Object)droppedColumn.getLayoutComponent().getDragTypeName());
        Util.assertEquals((Object)dropRow, (Object)this.getRowByIndex(1));
        ((EventSourceMock)Mockito.verify((Object)this.componentDropEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ComponentDropEvent.class));
    }

    @Test
    public void moveComponentShouldRemoveComponentFromCurrentRow() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row dropRow = this.getRowByIndex(0);
        RowDrop moveComponentAndDropInFirstRow = new RowDrop(new LayoutComponent("dragType"), dropRow.getId(), RowDrop.Orientation.BEFORE);
        moveComponentAndDropInFirstRow.fromMove(dropRow.getId(), this.getColumns(dropRow).get(0));
        this.container.createRowDropCommand().execute((Object)moveComponentAndDropInFirstRow);
        Util.assertEquals((Object)2, (Object)this.getRowsSizeFromContainer());
        Util.assertEquals((Object)1, (Object)this.getColumns(this.getRowByIndex(0)).size());
        Util.assertEquals((Object)1, (Object)this.getColumns(this.getRowByIndex(1)).size());
        ((EventSourceMock)Mockito.verify((Object)this.componentDropEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ComponentDropEvent.class));
        ((EventSourceMock)Mockito.verify((Object)this.componentRemoveEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ComponentRemovedEvent.class));
    }

    @Test
    public void swapRows() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/sampleFullFluidLayout.txt");
        Row row1 = this.getRowByIndex(0);
        Row row2 = this.getRowByIndex(1);
        this.container.swapRows(new RowDnDEvent(row1.getId(), row2.getId(), RowDrop.Orientation.AFTER));
        Util.assertEquals((Object)row2, (Object)this.getRowByIndex(0));
        Util.assertEquals((Object)row1, (Object)this.getRowByIndex(1));
    }

    @Test
    public void dropAfterComponentShouldCreateANewRow() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayout.txt");
        Row dropRow = this.getRowByIndex(0);
        ParameterizedCommand rowDropCommand = this.container.createRowDropCommand();
        RowDrop drop = new RowDrop(new LayoutComponent("dragType"), dropRow.getId(), RowDrop.Orientation.AFTER);
        drop.newComponent();
        rowDropCommand.execute((Object)drop);
        Util.assertEquals((Object)2, (Object)this.getRowsSizeFromContainer());
        Util.assertEquals((Object)dropRow, (Object)this.getRowByIndex(0));
        ((EventSourceMock)Mockito.verify((Object)this.componentDropEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ComponentDropEvent.class));
    }

    @Test
    public void removeSingleComponentFromRowShouldRemoveRow() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayout.txt");
        Assert.assertFalse((boolean)this.container.getRows().isEmpty());
        Row row = this.getRowByIndex(0);
        ComponentColumn column = (ComponentColumn)this.getColumns(row).get(0);
        column.remove();
        Assert.assertTrue((boolean)this.container.getRows().isEmpty());
    }

    @Test
    public void addGetPropertyTest() throws Exception {
        Assert.assertNull((Object)this.container.getProperty("key"));
        this.container.addProperty("key", "value");
        Assert.assertNotNull((Object)this.container.getProperty("key"));
        Assert.assertTrue((boolean)this.container.getProperties().containsKey("key"));
    }

    @Test
    public void createCurrentLayoutTemplateSupplierTest() throws Exception {
        LayoutTemplate expected = this.loadLayout("org/uberfire/ext/layout/editor/client/sampleFullFluidLayout.txt");
        LayoutTemplate toLayoutTemplate = this.container.toLayoutTemplate();
        Supplier currentLayoutTemplateSupplier = this.container.createCurrentLayoutTemplateSupplier();
        Util.assertEquals((Object)expected, (Object)toLayoutTemplate);
        Util.assertEquals((Object)expected, currentLayoutTemplateSupplier.get());
    }
}

