/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.components.rows;

import java.util.List;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.client.AbstractLayoutEditorTest;
import org.uberfire.ext.layout.editor.client.api.ComponentDropEvent;
import org.uberfire.ext.layout.editor.client.api.ComponentRemovedEvent;
import org.uberfire.ext.layout.editor.client.components.columns.Column;
import org.uberfire.ext.layout.editor.client.components.columns.ColumnWithComponents;
import org.uberfire.ext.layout.editor.client.components.columns.ComponentColumn;
import org.uberfire.ext.layout.editor.client.components.rows.Row;
import org.uberfire.ext.layout.editor.client.components.rows.RowDrop;
import org.uberfire.ext.layout.editor.client.infra.ColumnDrop;
import org.uberfire.ext.layout.editor.client.infra.ColumnResizeEvent;
import org.uberfire.mocks.EventSourceMock;

public class RowTest
extends AbstractLayoutEditorTest {
    @Test
    public void dropOnLeftColumn() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column dropColumn = this.getColumnByIndex(row, 0);
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("dragType"), dropColumn.getId(), ColumnDrop.Orientation.LEFT));
        Column newColumn = this.getColumnByIndex(row, 0);
        Util.assertEquals((Object)3, (Object)row.getColumns().size());
        Util.assertEquals((Object)"dragType", (Object)newColumn.getLayoutComponent().getDragTypeName());
        Util.assertEquals((Object)dropColumn, (Object)this.getColumnByIndex(row, 1));
    }

    @Test
    public void dropOnRightColumn() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column dropColumn = this.getColumnByIndex(row, 0);
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("dragType"), dropColumn.getId(), ColumnDrop.Orientation.RIGHT));
        Column newColumn = this.getColumnByIndex(row, 1);
        Util.assertEquals((Object)3, (Object)row.getColumns().size());
        Util.assertEquals((Object)"dragType", (Object)newColumn.getLayoutComponent().getDragTypeName());
        Util.assertEquals((Object)dropColumn, (Object)this.getColumnByIndex(row, 0));
    }

    @Test
    public void dropAboveColumnShouldCreateColumnWithComponents() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column dropColumn = this.getColumnByIndex(row, 0);
        LayoutComponent originalColumnLayoutComponent = dropColumn.getLayoutComponent();
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("dragType"), dropColumn.getId(), ColumnDrop.Orientation.DOWN));
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        ColumnWithComponents columnWithComponents = (ColumnWithComponents)this.getColumnByIndex(row, 0);
        List<Column> childs = this.extractColumnsFrom(columnWithComponents);
        Util.assertEquals((Object)2, (Object)childs.size());
        Util.assertEquals((Object)originalColumnLayoutComponent, (Object)childs.get(0).getLayoutComponent());
        LayoutComponent newColumnLayoutComponent = childs.get(1).getLayoutComponent();
        Util.assertEquals((Object)"dragType", (Object)newColumnLayoutComponent.getDragTypeName());
    }

    @Test
    public void dropUpperColumnShouldCreateColumnWithComponents() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column dropColumn = this.getColumnByIndex(row, 1);
        LayoutComponent originalColumnLayoutComponent = dropColumn.getLayoutComponent();
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("dragType"), dropColumn.getId(), ColumnDrop.Orientation.UP));
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        ColumnWithComponents columnWithComponents = (ColumnWithComponents)this.getColumnByIndex(row, 1);
        List<Column> childs = this.extractColumnsFrom(columnWithComponents);
        Util.assertEquals((Object)2, (Object)childs.size());
        LayoutComponent newColumnLayoutComponent = childs.get(0).getLayoutComponent();
        Util.assertEquals((Object)"dragType", (Object)newColumnLayoutComponent.getDragTypeName());
        Util.assertEquals((Object)originalColumnLayoutComponent, (Object)childs.get(1).getLayoutComponent());
    }

    @Test
    public void resizeEventTest() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column first = this.getColumnByIndex(row, 0);
        Column second = this.getColumnByIndex(this.getRowByIndex(0), 1);
        Integer originalFirstSize = first.getColumnWidth();
        Integer originalSecondSize = second.getColumnWidth();
        row.resizeColumns(new ColumnResizeEvent(second.getId(), row.getId()).left());
        Util.assertEquals((Object)(originalFirstSize - 1), (Object)first.getColumnWidth());
        Util.assertEquals((Object)(originalSecondSize + 1), (Object)second.getColumnWidth());
        row.resizeColumns(new ColumnResizeEvent(second.getId(), row.getId()).left());
        Util.assertEquals((Object)(originalFirstSize - 2), (Object)first.getColumnWidth());
        Util.assertEquals((Object)(originalSecondSize + 2), (Object)second.getColumnWidth());
        row.resizeColumns(new ColumnResizeEvent(first.getId(), row.getId()).right());
        Util.assertEquals((Object)(originalFirstSize - 1), (Object)first.getColumnWidth());
        Util.assertEquals((Object)(originalSecondSize + 1), (Object)second.getColumnWidth());
    }

    @Test
    public void testRemoveElementInColumnWithComponents() throws Exception {
        ArgumentCaptor removeEventCaptor = ArgumentCaptor.forClass(ComponentRemovedEvent.class);
        this.loadLayout("org/uberfire/ext/layout/editor/client/columnWithComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Assertions.assertThat((List)row.getColumns()).hasSize(1);
        Column rowColumn = (Column)row.getColumns().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)rowColumn).isNotNull()).isInstanceOf(ColumnWithComponents.class);
        ColumnWithComponents columnWithComponents = (ColumnWithComponents)rowColumn;
        Assertions.assertThat((List)columnWithComponents.getRow().getColumns()).hasSize(3);
        Column firstColumn = (Column)columnWithComponents.getRow().getColumns().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)firstColumn).isNotNull()).isInstanceOf(ComponentColumn.class);
        Column secondColumn = (Column)columnWithComponents.getRow().getColumns().get(1);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondColumn).isNotNull()).isInstanceOf(ComponentColumn.class);
        Column thirdColumn = (Column)columnWithComponents.getRow().getColumns().get(2);
        ((AbstractObjectAssert)Assertions.assertThat((Object)thirdColumn).isNotNull()).isInstanceOf(ComponentColumn.class);
        row.removeColumn(thirdColumn);
        rowColumn = (Column)row.getColumns().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)rowColumn).isNotNull()).isInstanceOf(ColumnWithComponents.class);
        ((EventSourceMock)Mockito.verify((Object)this.componentRemoveEventMock, (VerificationMode)Mockito.times((int)1))).fire(removeEventCaptor.capture());
        Assert.assertFalse((boolean)((ComponentRemovedEvent)removeEventCaptor.getValue()).getFromMove());
        columnWithComponents = (ColumnWithComponents)rowColumn;
        ((ListAssert)Assertions.assertThat((List)columnWithComponents.getRow().getColumns()).hasSize(2)).contains((Object[])new Column[]{firstColumn, secondColumn});
        row.removeColumn(firstColumn);
        ((EventSourceMock)Mockito.verify((Object)this.componentRemoveEventMock, (VerificationMode)Mockito.times((int)2))).fire(removeEventCaptor.capture());
        Assert.assertFalse((boolean)((ComponentRemovedEvent)removeEventCaptor.getValue()).getFromMove());
        Assertions.assertThat((List)row.getColumns()).hasSize(1);
        rowColumn = (Column)row.getColumns().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)rowColumn).isNotNull()).isInstanceOf(ComponentColumn.class);
        Assertions.assertThat((Object)rowColumn).isEqualToComparingOnlyGivenFields((Object)secondColumn, new String[]{"columnWidth", "columnHeight", "layoutComponent"});
    }

    @Test
    public void moveElementInRow() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/columnWithComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Assertions.assertThat((List)row.getColumns()).hasSize(1);
        Column rowColumn = (Column)row.getColumns().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)rowColumn).isNotNull()).isInstanceOf(ColumnWithComponents.class);
        ColumnWithComponents columnWithComponents = (ColumnWithComponents)rowColumn;
        Assertions.assertThat((List)columnWithComponents.getRow().getColumns()).hasSize(3);
        Column column = (Column)columnWithComponents.getRow().getColumns().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)column).isNotNull()).isInstanceOf(ComponentColumn.class);
        this.dnDManager.dragComponent(column.getLayoutComponent(), columnWithComponents.getRow().getId(), column);
        row.removeColumn(column);
        rowColumn = (Column)row.getColumns().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)rowColumn).isNotNull()).isInstanceOf(ColumnWithComponents.class);
        ArgumentCaptor removeEventCaptor = ArgumentCaptor.forClass(ComponentRemovedEvent.class);
        ((EventSourceMock)Mockito.verify((Object)this.componentRemoveEventMock, (VerificationMode)Mockito.times((int)1))).fire(removeEventCaptor.capture());
        Assert.assertTrue((boolean)((ComponentRemovedEvent)removeEventCaptor.getValue()).getFromMove());
        Assert.assertTrue((boolean)this.dnDManager.isOnComponentMove());
        row.drop("", RowDrop.Orientation.BEFORE);
        ArgumentCaptor dropEventCaptor = ArgumentCaptor.forClass(ComponentDropEvent.class);
        ((EventSourceMock)Mockito.verify((Object)this.componentDropEventMock)).fire(dropEventCaptor.capture());
        Assert.assertTrue((boolean)((ComponentDropEvent)dropEventCaptor.getValue()).getFromMove());
        Assert.assertTrue((boolean)this.dnDManager.isOnComponentMove());
    }
}

