/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.infra;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;
import org.uberfire.ext.layout.editor.client.infra.LayoutDragComponentHelper;

@RunWith(value=MockitoJUnitRunner.class)
public class LayoutDragComponentHelperTest {
    @Mock
    private SyncBeanManager beanManager;
    @Mock
    private ClientExperimentalFeaturesRegistryService experimentalFeaturesRegistryService;
    private LayoutDragComponentHelper helper;
    private SyncBeanDef<LayoutDragComponent> beanDefMock;

    @Before
    public void initialize() {
        this.helper = this.createLayoutDragMock();
        this.beanDefMock = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        List<SyncBeanDef> beanDefs = Arrays.asList(this.beanDefMock);
        Mockito.when((Object)this.beanManager.lookupBeans(LayoutDragComponent.class)).thenReturn(beanDefs);
    }

    @Test
    public void lookupBeanShouldRespectBeanScope() {
        this.helper.lookupDragTypeBean(LayoutDragComponentMock.class.getName());
        ((SyncBeanDef)Mockito.verify(this.beanDefMock)).getInstance();
        ((SyncBeanDef)Mockito.verify(this.beanDefMock, (VerificationMode)Mockito.never())).newInstance();
    }

    private LayoutDragComponentHelper createLayoutDragMock() {
        return new LayoutDragComponentHelper(this.beanManager, this.experimentalFeaturesRegistryService){

            Predicate<SyncBeanDef<LayoutDragComponent>> syncBeanDefBeanClassNamePredicate(String dragTypeClassName) {
                return s -> true;
            }

            boolean isAnEnabledExperimentalFeature(SyncBeanDef<LayoutDragComponent> beanDef) {
                return true;
            }
        };
    }

    public static class LayoutDragComponentMock
    implements LayoutDragComponent {
        public String getDragComponentTitle() {
            return null;
        }

        public IsWidget getPreviewWidget(RenderingContext ctx) {
            return null;
        }

        public IsWidget getShowWidget(RenderingContext ctx) {
            return null;
        }
    }
}

