/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.infra;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.uberfire.ext.layout.editor.api.css.CssAllowedValue;
import org.uberfire.ext.layout.editor.api.css.CssFontSize;
import org.uberfire.ext.layout.editor.api.css.CssProperty;
import org.uberfire.ext.layout.editor.api.css.CssValue;
import org.uberfire.ext.layout.editor.client.infra.LayoutEditorCssHelper;

@RunWith(value=GwtMockitoTestRunner.class)
public class LayoutEditorCssHelperTest {
    private LayoutEditorCssHelper cssHelper;

    @Before
    public void setup() {
        this.cssHelper = (LayoutEditorCssHelper)Mockito.spy((Object)new LayoutEditorCssHelper());
    }

    @Test
    public void testReadFromMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CssProperty.MARGIN_TOP.getName(), "100px");
        properties.put("prop1", "v1");
        List cssValueList = this.cssHelper.readCssValues(properties);
        Assert.assertEquals((long)cssValueList.size(), (long)1L);
        Assert.assertEquals((Object)((CssValue)cssValueList.get(0)).getProperty(), (Object)"margin-top");
        Assert.assertEquals((Object)((CssValue)cssValueList.get(0)).getValue(), (Object)"100px");
    }

    @Test
    public void testParseAllowedValue() {
        Mockito.when((Object)this.cssHelper.formatCssAllowedValue(CssProperty.FONT_SIZE, (CssAllowedValue)CssFontSize.XX_LARGE)).thenReturn((Object)"Extra Large");
        CssAllowedValue cssAllowedValue = this.cssHelper.parseCssAllowedValue(CssProperty.FONT_SIZE, "Extra Large");
        Assert.assertEquals((Object)cssAllowedValue.getName(), (Object)"xx-large");
    }
}

