/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.infra;

import elemental2.dom.CSSStyleDeclaration;
import elemental2.dom.HTMLElement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.layout.editor.client.infra.LayoutEditorFocusController;

@RunWith(value=MockitoJUnitRunner.class)
public class LayoutEditorFocusControllerTest {
    LayoutEditorFocusController controller = new LayoutEditorFocusController();

    @Test
    public void noScrollableParentTest() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        HTMLElement foundScrollParent = this.controller.findScrollableParent(element);
        Assert.assertNull((Object)foundScrollParent);
    }

    @Test
    public void withScrollableParentTest() {
        HTMLElement scrollParent = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        CSSStyleDeclaration style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        style.overflow = "auto";
        scrollParent.style = style;
        element.parentNode = scrollParent;
        element.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        HTMLElement foundScrollParent = this.controller.findScrollableParent(element);
        Assert.assertEquals((Object)scrollParent, (Object)foundScrollParent);
    }

    @Test
    public void scrollRecoveryTest() {
        int initialScrollLeft = -1;
        int initialScrollTop = -5;
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        this.controller.setScrollableElement(element);
        element.scrollLeft = -1.0;
        element.scrollTop = -5.0;
        this.controller.recordFocus();
        Assert.assertTrue((boolean)this.controller.isDirty());
        element.scrollLeft = 0.0;
        element.scrollTop = 0.0;
        this.controller.restoreFocus();
        Assert.assertFalse((boolean)this.controller.isDirty());
        Assert.assertEquals((double)-1.0, (double)element.scrollLeft, (double)0.001);
        Assert.assertEquals((double)-5.0, (double)element.scrollTop, (double)0.001);
    }
}

