/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentGroup;
import org.uberfire.ext.layout.editor.client.test.group1.Group1LayoutComponentPaletteGroupProvider;
import org.uberfire.ext.layout.editor.client.test.group1.Group1LayoutDragComponent1;
import org.uberfire.ext.layout.editor.client.test.group1.Group1LayoutDragComponent3;
import org.uberfire.ext.layout.editor.client.test.group2.Group2LayoutComponentPaletteGroupProvider;
import org.uberfire.ext.layout.editor.client.test.group3.Group3LayoutComponentPaletteGroupProvider;
import org.uberfire.ext.layout.editor.client.test.group3.Group3LayoutDragComponent1;
import org.uberfire.ext.layout.editor.client.widgets.LayoutComponentPalettePresenter;
import org.uberfire.ext.layout.editor.client.widgets.LayoutDragComponentGroupPresenter;

@RunWith(value=MockitoJUnitRunner.class)
public class LayoutComponentPalettePresenterTest {
    public static final String DRAGGABLE_COMPONENT_NAME = "Draggable component name";
    @Mock
    private LayoutComponentPalettePresenter.View view;
    @Mock
    private LayoutDragComponentGroupPresenter.View dragComponentGroupView;
    @Mock
    private ClientExperimentalFeaturesRegistryService experimentalFeaturesRegistryService;
    private LayoutDragComponentGroupPresenter dragComponentGroupPresenter;
    private LayoutComponentPalettePresenter presenter;
    private List<String> disabledExperimentalFeatures = new ArrayList<String>();
    private List<String> currentDragComponents = new ArrayList<String>();

    @Before
    public void initialize() {
        Mockito.when((Object)this.experimentalFeaturesRegistryService.isFeatureEnabled(Mockito.anyString())).thenAnswer(invocationOnMock -> !this.disabledExperimentalFeatures.contains(invocationOnMock.getArguments()[0]));
        ManagedInstance instance = (ManagedInstance)Mockito.mock(ManagedInstance.class);
        this.dragComponentGroupPresenter = (LayoutDragComponentGroupPresenter)Mockito.spy((Object)new LayoutDragComponentGroupPresenter(this.dragComponentGroupView));
        Mockito.when((Object)instance.get()).thenReturn((Object)this.dragComponentGroupPresenter);
        ((LayoutDragComponentGroupPresenter)Mockito.doAnswer(invocationOnMock -> {
            invocationOnMock.callRealMethod();
            LayoutDragComponentGroup group = (LayoutDragComponentGroup)invocationOnMock.getArguments()[0];
            this.currentDragComponents.addAll(group.getComponents().keySet());
            return null;
        }).when((Object)this.dragComponentGroupPresenter)).init((LayoutDragComponentGroup)ArgumentMatchers.any());
        Mockito.when((Object)this.dragComponentGroupView.hasComponent(Mockito.anyString())).then((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                return LayoutComponentPalettePresenterTest.this.currentDragComponents.contains(invocationOnMock.getArguments()[0]);
            }
        });
        this.presenter = new LayoutComponentPalettePresenter(this.view, instance, this.experimentalFeaturesRegistryService);
    }

    @Test
    public void testInitialization() {
        ((LayoutComponentPalettePresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testAddAllDraggableGroups() {
        this.presenter.addDraggableGroups(Arrays.asList(new Group1LayoutComponentPaletteGroupProvider(true), new Group2LayoutComponentPaletteGroupProvider(), new Group3LayoutComponentPaletteGroupProvider()));
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)3))).init((LayoutDragComponentGroup)ArgumentMatchers.any());
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)3))).getView();
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setExpanded(true);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView, (VerificationMode)Mockito.times((int)2))).setExpanded(false);
        ((LayoutComponentPalettePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addDraggableComponentGroup((UberElement)ArgumentMatchers.any());
        Assert.assertEquals((long)3L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNotNull(this.presenter.getLayoutDragComponentGroups().get("Group1"));
        Assert.assertTrue((boolean)this.presenter.hasDraggableComponent("Group1", "Group1Component1"));
        Assert.assertTrue((boolean)this.presenter.hasDraggableComponent("Group1", "Group1Component2"));
        Assert.assertTrue((boolean)this.presenter.hasDraggableComponent("Group1", "Group1Component3"));
        Assert.assertNotNull(this.presenter.getLayoutDragComponentGroups().get("Group2"));
        Assert.assertTrue((boolean)this.presenter.hasDraggableComponent("Group2", "Group2Component1"));
        Assert.assertTrue((boolean)this.presenter.hasDraggableComponent("Group2", "Group2Component2"));
        Assert.assertNotNull(this.presenter.getLayoutDragComponentGroups().get("Group3"));
        Assert.assertTrue((boolean)this.presenter.hasDraggableComponent("Group3", "Group3Component1"));
        LayoutDragComponent dragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.presenter.addDraggableComponent("Group1", DRAGGABLE_COMPONENT_NAME, dragComponent);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).addComponent(DRAGGABLE_COMPONENT_NAME, dragComponent);
        this.presenter.removeDraggableComponent("Group1", DRAGGABLE_COMPONENT_NAME);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).removeComponent(DRAGGABLE_COMPONENT_NAME);
    }

    @Test
    public void testAddDraggableGroupsWithExperimental() {
        this.disabledExperimentalFeatures.add(Group1LayoutDragComponent1.class.getName());
        this.disabledExperimentalFeatures.add(Group1LayoutDragComponent3.class.getName());
        this.disabledExperimentalFeatures.add(Group2LayoutComponentPaletteGroupProvider.class.getName());
        this.disabledExperimentalFeatures.add(Group3LayoutDragComponent1.class.getName());
        this.presenter.addDraggableGroups(Arrays.asList(new Group1LayoutComponentPaletteGroupProvider(true), new Group2LayoutComponentPaletteGroupProvider(), new Group3LayoutComponentPaletteGroupProvider()));
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)2))).init((LayoutDragComponentGroup)ArgumentMatchers.any());
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)2))).getView();
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setExpanded(true);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setExpanded(false);
        ((LayoutComponentPalettePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addDraggableComponentGroup((UberElement)ArgumentMatchers.any());
        Assert.assertEquals((long)2L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNotNull(this.presenter.getLayoutDragComponentGroups().get("Group1"));
        Assert.assertFalse((boolean)this.presenter.hasDraggableComponent("Group1", "Group1Component1"));
        Assert.assertTrue((boolean)this.presenter.hasDraggableComponent("Group1", "Group1Component2"));
        Assert.assertFalse((boolean)this.presenter.hasDraggableComponent("Group1", "Group1Component3"));
        Assert.assertNull(this.presenter.getLayoutDragComponentGroups().get("Group2"));
        Assert.assertFalse((boolean)this.presenter.hasDraggableComponent("Group2", "Group2Component1"));
        Assert.assertFalse((boolean)this.presenter.hasDraggableComponent("Group2", "Group2Component2"));
        Assert.assertNotNull(this.presenter.getLayoutDragComponentGroups().get("Group3"));
        Assert.assertFalse((boolean)this.presenter.hasDraggableComponent("Group3", "Group3Component1"));
    }

    @Test
    public void testAddAndRemoveDraggableGroups() {
        this.testAddAllDraggableGroups();
        this.presenter.removeDraggableGroup("Group1");
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)4))).getView();
        ((LayoutComponentPalettePresenter.View)Mockito.verify((Object)this.view)).removeDraggableComponentGroup((UberElement)ArgumentMatchers.any());
        Assert.assertEquals((long)2L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNull(this.presenter.getLayoutDragComponentGroups().get("Group1"));
    }

    @Test
    public void testClearPalette() {
        this.testAddAllDraggableGroups();
        this.presenter.clear();
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)6))).getView();
        ((LayoutComponentPalettePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).removeDraggableComponentGroup((UberElement)ArgumentMatchers.any());
        Assert.assertEquals((long)0L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNull(this.presenter.getLayoutDragComponentGroups().get("Group1"));
    }

    @Test
    public void testHasDraggableGroup() {
        Assert.assertFalse((boolean)this.presenter.hasDraggableGroup("Group1"));
        this.testAddAllDraggableGroups();
        Assert.assertTrue((boolean)this.presenter.hasDraggableGroup("Group1"));
    }

    @Test
    public void testHasDraggableComponent() {
        Assert.assertFalse((boolean)this.presenter.hasDraggableComponent("Group1", "Group1Component1"));
        this.testAddAllDraggableGroups();
        Assert.assertTrue((boolean)this.presenter.hasDraggableComponent("Group1", "Group1Component1"));
    }

    @Test
    public void testRemoveComponent() {
        this.testAddAllDraggableGroups();
        this.presenter.removeDraggableComponent("Group1", "Group1Component1");
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setComponentVisible("Group1Component1", false);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView, (VerificationMode)Mockito.never())).removeComponent("Group1Component1");
    }
}

