/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.components;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.AbstractLayoutEditorTest;
import org.uberfire.ext.layout.editor.client.components.columns.Column;
import org.uberfire.ext.layout.editor.client.components.columns.ColumnWithComponents;
import org.uberfire.ext.layout.editor.client.components.rows.Row;
import org.uberfire.ext.layout.editor.client.components.rows.RowDrop;
import org.uberfire.ext.layout.editor.client.infra.ColumnDrop;
import org.uberfire.ext.layout.editor.client.infra.ColumnResizeEvent;
import org.uberfire.ext.layout.editor.client.infra.RowResizeEvent;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class FullLayoutTest
extends AbstractLayoutEditorTest {
    @Test
    public void testFullLayoutFluid() throws Exception {
        this.container.loadEmptyLayout("A", LayoutTemplate.Style.FLUID, "title", "subtitle");
        this.container.addProperty("LAYOUT_TAGS", "a|");
        this.createFirstRow();
        this.createSecondRow();
        LayoutTemplate layoutTemplate = this.container.toLayoutTemplate();
        Assert.assertEquals((Object)this.convertLayoutToString(this.loadLayout("org/uberfire/ext/layout/editor/client/fullLayoutFluid.txt")), (Object)this.convertLayoutToString(layoutTemplate));
    }

    @Test
    public void testFullLayoutPage() throws Exception {
        this.container.loadEmptyLayout("A", LayoutTemplate.Style.PAGE, "title", "subtitle");
        this.container.addProperty("LAYOUT_TAGS", "a|");
        this.createFirstRow();
        this.createSecondRow();
        this.resizeSecondRow();
        this.resizeSecondRow();
        LayoutTemplate layoutTemplate = this.container.toLayoutTemplate();
        Assert.assertEquals((Object)this.convertLayoutToString(this.loadLayout("org/uberfire/ext/layout/editor/client/fullLayoutPage.txt")), (Object)this.convertLayoutToString(layoutTemplate));
    }

    private void resizeSecondRow() {
        Row firstRow = this.getRowByIndex(0);
        RowResizeEvent resize = new RowResizeEvent(this.container.hashCode(), firstRow.hashCode()).down();
        this.container.resizeRows(resize);
    }

    private void createSecondRow() {
        Row firstRow = this.getRowByIndex(0);
        this.container.createRowDropCommand().execute((Object)new RowDrop(new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent"), firstRow.getId(), RowDrop.Orientation.AFTER));
        Column column = this.getColumnByIndex(this.getRowByIndex(1), 0);
        column.getLayoutComponent().addProperty("Place Name", "DoraScreen");
    }

    private void createFirstRow() {
        Column firstRowFirstColumn = this.createFirstRowFirstColumn();
        this.createFirstRowSecondColumn(firstRowFirstColumn);
    }

    private void dropTwoInnerColumnsInSecondRow() {
        Row row = this.getRowByIndex(0);
        Column secondColumn = this.getColumnByIndex(row, 1);
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent"), secondColumn.getId(), ColumnDrop.Orientation.DOWN));
        ColumnWithComponents columnWithComponents = (ColumnWithComponents)this.getColumnByIndex(row, 1);
        Assert.assertNotNull((Object)columnWithComponents.getRow().getParentColumnWithComponents());
        Column newColumn = this.getColumnByIndex(columnWithComponents.getRow(), 1);
        newColumn.getLayoutComponent().addProperty("c", "c");
        newColumn.getLayoutComponent().addProperty("Place Name", "AnotherScreen");
    }

    private void resizeColumnsFor_8_4() {
        Row row = this.getRowByIndex(0);
        row.resizeColumns(new ColumnResizeEvent(this.getColumnByIndex(row, 0).hashCode(), row.hashCode()).right());
        row.resizeColumns(new ColumnResizeEvent(this.getColumnByIndex(row, 0).hashCode(), row.hashCode()).right());
    }

    private void createFirstRowSecondColumn(Column firstRowFirstColumn) {
        Row row = this.getRowByIndex(0);
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.HTML"), firstRowFirstColumn.getId(), ColumnDrop.Orientation.RIGHT));
        Column htmlColumn = this.getColumnByIndex(row, 1);
        htmlColumn.getLayoutComponent().addProperty("HTML_CODE", "c");
        this.resizeColumnsFor_8_4();
        this.dropTwoInnerColumnsInSecondRow();
    }

    private Column createFirstRowFirstColumn() {
        this.container.createEmptyDropCommand().execute((Object)new RowDrop(new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent"), this.emptyDropRow.getId(), RowDrop.Orientation.BEFORE));
        Column appHomePresenter = this.getColumnByIndex(this.getRowByIndex(0), 0);
        appHomePresenter.getLayoutComponent().addProperty("Place Name", "AppsHomePresenter");
        return appHomePresenter;
    }
}

