/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.layout.editor.client.api.LayoutEditorElement;
import org.uberfire.ext.layout.editor.client.api.LayoutElementWithProperties;
import org.uberfire.ext.layout.editor.client.event.LayoutElementClearAllPropertiesEvent;
import org.uberfire.ext.layout.editor.client.event.LayoutElementPropertyChangedEvent;
import org.uberfire.ext.layout.editor.client.infra.LayoutEditorCssHelper;
import org.uberfire.ext.layout.editor.client.widgets.LayoutElementPropertiesPresenter;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class LayoutElementPropertiesPresenterTest {
    @Mock
    LayoutEditorCssHelper cssHelper;
    @Mock
    EventSourceMock<LayoutElementPropertyChangedEvent> propertyChangedEvent;
    @Mock
    EventSourceMock<LayoutElementClearAllPropertiesEvent> propertyClearAllEvent;
    @Mock
    LayoutElementPropertiesPresenter.View view;
    @Mock
    LayoutEditorElement layoutElement;
    Map<String, String> elementProps = new HashMap<String, String>();
    PropertyEditorCategory category1 = new PropertyEditorCategory("c1");
    PropertyEditorCategory category2 = new PropertyEditorCategory("c2");
    LayoutElementPropertiesPresenter presenter;

    @Before
    public void initialize() {
        ArrayList<PropertyEditorCategory> categories = new ArrayList<PropertyEditorCategory>();
        this.category1 = new PropertyEditorCategory("c1");
        this.category1.withField(new PropertyEditorFieldInfo("f1", "v1", PropertyEditorType.TEXT).withKey("f1"));
        categories.add(this.category1);
        this.category2 = new PropertyEditorCategory("c2");
        this.category2.withField(new PropertyEditorFieldInfo("f2", "v2", PropertyEditorType.TEXT).withKey("f2"));
        categories.add(this.category2);
        Mockito.when((Object)this.layoutElement.getProperties()).thenReturn(this.elementProps);
        Mockito.when((Object)this.layoutElement.getPropertyCategories()).thenReturn(categories);
        this.presenter = new LayoutElementPropertiesPresenter(this.view, this.cssHelper, this.propertyChangedEvent, this.propertyClearAllEvent);
        this.presenter.edit((LayoutElementWithProperties)this.layoutElement);
    }

    @Test
    public void testInit() {
        ((LayoutElementPropertiesPresenter.View)Mockito.verify((Object)this.view)).clear();
        ((LayoutElementPropertiesPresenter.View)Mockito.verify((Object)this.view)).addCategory(this.category1);
        ((LayoutElementPropertiesPresenter.View)Mockito.verify((Object)this.view)).addCategory(this.category2);
        ((LayoutElementPropertiesPresenter.View)Mockito.verify((Object)this.view)).show();
        Assert.assertEquals(this.presenter.getCurrentValues().get("f1"), (Object)"v1");
        Assert.assertEquals(this.presenter.getCurrentValues().get("f2"), (Object)"v2");
    }

    @Test
    public void testReset() {
        this.presenter.reset();
        Assert.assertTrue((boolean)this.presenter.getCurrentValues().isEmpty());
        ((LayoutEditorElement)Mockito.verify((Object)this.layoutElement)).removeProperty("f1");
        ((LayoutEditorElement)Mockito.verify((Object)this.layoutElement)).removeProperty("f2");
        ((EventSourceMock)Mockito.verify(this.propertyClearAllEvent)).fire(ArgumentMatchers.any());
    }

    @Test
    public void testChangeValue() {
        Assert.assertEquals(this.presenter.getCurrentValues().get("f1"), (Object)"v1");
        this.presenter.onPropertyChanged("f1", "v2");
        ((LayoutEditorElement)Mockito.verify((Object)this.layoutElement)).setProperty("f1", "v2");
        ((EventSourceMock)Mockito.verify(this.propertyChangedEvent)).fire(ArgumentMatchers.any());
        Assert.assertEquals(this.presenter.getCurrentValues().get("f1"), (Object)"v2");
    }

    @Test
    public void testRemoveValue() {
        Assert.assertEquals(this.presenter.getCurrentValues().get("f1"), (Object)"v1");
        this.presenter.onPropertyChanged("f1", "");
        ((LayoutEditorElement)Mockito.verify((Object)this.layoutElement)).removeProperty("f1");
        ((EventSourceMock)Mockito.verify(this.propertyChangedEvent)).fire(ArgumentMatchers.any());
        Assert.assertFalse((boolean)this.presenter.getCurrentValues().containsKey("f1"));
    }
}

