/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.components.columns;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.LockRequiredEvent;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponentPart;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.AbstractLayoutEditorTest;
import org.uberfire.ext.layout.editor.client.api.LayoutEditorElement;
import org.uberfire.ext.layout.editor.client.components.columns.Column;
import org.uberfire.ext.layout.editor.client.components.columns.ComponentColumn;
import org.uberfire.ext.layout.editor.client.infra.ColumnDrop;
import org.uberfire.ext.layout.editor.client.infra.DragComponentEndEvent;
import org.uberfire.mvp.ParameterizedCommand;

public class ComponentColumnTest
extends AbstractLayoutEditorTest {
    @Mock
    private Event<LockRequiredEvent> lockRequiredEvent;
    @Spy
    @InjectMocks
    private ComponentColumn componentColumn;
    @Mock
    private LayoutEditorElement parent;
    @Mock
    private LayoutComponent layoutComponent;
    @Mock
    private ParameterizedCommand<ColumnDrop> dropCommand;
    @Mock
    private ParameterizedCommand<Column> removeCommand;
    @Mock
    private Supplier<LayoutTemplate> currentLayoutTemplateSupplier;
    @Mock
    private Supplier<Boolean> lockSupplier;
    @Mock
    private ComponentColumn.View view;

    @Test
    public void assertThereIsNoGWTDepInComponentColumn() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
    }

    @Test
    public void emptyPartsWontBreakTest() throws Exception {
        LayoutTemplate layout = this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayout.txt");
        List parts = ((LayoutComponent)((LayoutColumn)((LayoutRow)layout.getRows().get(0)).getLayoutColumns().get(0)).getLayoutComponents().get(0)).getParts();
        Assert.assertTrue((boolean)parts.isEmpty());
    }

    @Test
    public void partsLoadingTest() throws Exception {
        LayoutTemplate layout = this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayoutWithParts.txt");
        List parts = ((LayoutComponent)((LayoutColumn)((LayoutRow)layout.getRows().get(0)).getLayoutColumns().get(0)).getLayoutComponents().get(0)).getParts();
        Assert.assertEquals((long)2L, (long)parts.size());
        Optional<LayoutComponentPart> part1Op = parts.stream().filter(p -> p.getPartId().equals("PART1")).findFirst();
        Assert.assertTrue((boolean)part1Op.isPresent());
        LayoutComponentPart part1 = part1Op.get();
        Assert.assertTrue((boolean)part1.getCssProperties().containsKey("PROP1"));
        Assert.assertEquals((Object)"PROP1_VAL", part1.getCssProperties().get("PROP1"));
        part1.clearCssProperties();
        Assert.assertTrue((boolean)part1.getCssProperties().isEmpty());
        part1.addCssProperty("NEW_PROP", "NEW_VALUE");
        Assert.assertEquals((Object)"NEW_VALUE", part1.getCssProperties().get("NEW_PROP"));
    }

    @Test
    public void testOnDrop() {
        this.componentColumn.onDrop(ColumnDrop.Orientation.UP, "this-is-a-requirement-to-firefox-html5dnd");
        ((Event)Mockito.verify(this.lockRequiredEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((LockRequiredEvent)ArgumentMatchers.any(LockRequiredEvent.class)));
    }

    @Test
    public void testRequiredLock() {
        this.componentColumn.requiredLock();
        ((Event)Mockito.verify(this.lockRequiredEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((LockRequiredEvent)ArgumentMatchers.any(LockRequiredEvent.class)));
    }

    @Test
    public void onDragEnd() {
        this.componentColumn.onDragEnd(new DragComponentEndEvent());
        ((ComponentColumn.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).notifyDragEnd();
        ((Event)Mockito.verify(this.lockRequiredEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((LockRequiredEvent)ArgumentMatchers.any(LockRequiredEvent.class)));
    }

    @Test
    public void testConfigComponentSupplier() {
        Mockito.when((Object)this.lockSupplier.get()).thenReturn((Object)true);
        this.componentColumn.configComponent(true);
        ((ComponentColumn.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hasModalConfiguration();
    }

    @Test
    public void testConfigComponent() {
        Mockito.when((Object)this.lockSupplier.get()).thenReturn((Object)false);
        Mockito.when((Object)this.view.hasModalConfiguration()).thenReturn((Object)true);
        this.componentColumn.configComponent(true);
        ((ComponentColumn.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hasModalConfiguration();
    }
}

