/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.client.api.LayoutEditor;
import org.uberfire.ext.layout.editor.client.api.LayoutEditorElement;
import org.uberfire.ext.layout.editor.client.api.LayoutEditorElementPart;
import org.uberfire.ext.layout.editor.client.api.LayoutEditorElementType;
import org.uberfire.ext.layout.editor.client.api.LayoutElementWithProperties;
import org.uberfire.ext.layout.editor.client.widgets.LayoutEditorPropertiesPresenter;
import org.uberfire.ext.layout.editor.client.widgets.LayoutElementPropertiesPresenter;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchEntry;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchSelectionHandler;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;
import org.uberfire.ext.widgets.common.client.dropdown.SingleLiveSearchSelectionHandler;

@RunWith(value=MockitoJUnitRunner.class)
public class LayoutEditorPropertiesPresenterTest {
    private LayoutEditorPropertiesPresenter.View view = (LayoutEditorPropertiesPresenter.View)Mockito.spy((Object)new LayoutEditorPropertiesPresenter.View(){

        public void dispose() {
        }

        public void showSelector(IsWidget selectorView) {
        }

        public void showElement(IsWidget elementView) {
        }

        public String getDisplayPosition(String parentPosition, String elementName, String elementIndex) {
            return parentPosition + " > " + elementName + " " + elementIndex;
        }

        public String getDisplayName(String elementName, String elementIndex) {
            return elementName + " " + elementIndex;
        }

        public String getLayoutElementTypePage() {
            return "page";
        }

        public String getLayoutElementTypeRow() {
            return "row";
        }

        public String getLayoutElementTypeColumn() {
            return "column";
        }

        public String getLayoutElementTypeComponent() {
            return "component";
        }

        public void setClearPropertiesEnabled(boolean enabled) {
        }

        public void init(LayoutEditorPropertiesPresenter presenter) {
        }

        public HTMLElement getElement() {
            return null;
        }

        public void noParts() {
        }

        public void showParts(List<String> parts) {
        }
    });
    @Mock
    private ManagedInstance<LayoutElementPropertiesPresenter> layoutElementPropertiesPresenterInstance;
    @Mock
    private LayoutEditor layoutEditor;
    @Mock
    private LiveSearchDropDown<String> elementSelector;
    @Mock
    private LayoutElementPropertiesPresenter elementPropertiesPresenter;
    LayoutElementPartTest PART_1 = new LayoutElementPartTest("P1");
    LayoutElementPartTest PART_2 = new LayoutElementPartTest("P2");
    List<LayoutElementPartTest> columnParts = Arrays.asList(this.PART_1, this.PART_2);
    LayoutElementTest column1 = new LayoutElementTest("1", LayoutEditorElementType.COLUMN, new ArrayList<LayoutElementTest>());
    LayoutElementTest column2 = new LayoutElementTest("2", LayoutEditorElementType.COLUMN, new ArrayList<LayoutElementTest>());
    LayoutElementTest column4 = new LayoutElementTest("1", LayoutEditorElementType.COLUMN, new ArrayList<LayoutElementTest>());
    LayoutElementTest column5 = new LayoutElementTest("2", LayoutEditorElementType.COLUMN, new ArrayList<LayoutElementTest>());
    LayoutElementTest columnWithParts = new LayoutElementTest("CPARTS", LayoutEditorElementType.COLUMN, new ArrayList<LayoutElementTest>(), this.columnParts);
    LayoutElementTest rowcol3 = new LayoutElementTest("1", LayoutEditorElementType.ROW, Arrays.asList(this.column4, this.column5, this.columnWithParts));
    LayoutElementTest column3 = new LayoutElementTest("2", LayoutEditorElementType.COLUMN_WITH_COMPONENTS, Arrays.asList(this.rowcol3));
    LayoutElementTest row1 = new LayoutElementTest("1", LayoutEditorElementType.ROW, Arrays.asList(this.column1, this.column2));
    LayoutElementTest row2 = new LayoutElementTest("2", LayoutEditorElementType.ROW, Arrays.asList(this.column3));
    LayoutElementTest container = new LayoutElementTest("container", LayoutEditorElementType.CONTAINER, Arrays.asList(this.row1, this.row2));
    private LayoutEditorPropertiesPresenter presenter;

    @Before
    public void initialize() {
        Mockito.when((Object)((LayoutElementPropertiesPresenter)this.layoutElementPropertiesPresenterInstance.get())).thenReturn((Object)this.elementPropertiesPresenter);
        Mockito.when((Object)this.layoutEditor.getLayoutElements()).thenReturn(Arrays.asList(this.container, this.row1, this.column1, this.column2, this.row2, this.column3, this.rowcol3, this.column4, this.column5, this.columnWithParts));
        this.presenter = new LayoutEditorPropertiesPresenter(this.view, this.layoutElementPropertiesPresenterInstance, this.elementSelector);
    }

    @Test
    public void testInit() {
        this.elementSelector.setSearchEnabled(false);
        this.elementSelector.setClearSelectionEnabled(false);
        this.elementSelector.setWidth(275);
        this.elementSelector.init((LiveSearchService)Mockito.eq((Object)this.presenter.getSearchService()), (LiveSearchSelectionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testEditLayout() {
        this.presenter.edit(this.layoutEditor);
        ((LayoutEditorPropertiesPresenter.View)Mockito.verify((Object)this.view)).dispose();
        ((LayoutEditorPropertiesPresenter.View)Mockito.verify((Object)this.view)).showSelector(this.elementSelector);
        ((LayoutEditorPropertiesPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setClearPropertiesEnabled(true);
        ((LiveSearchDropDown)Mockito.verify(this.elementSelector)).clear();
        ((LiveSearchDropDown)Mockito.verify(this.elementSelector)).setSelectedItem((Object)"container");
        ((LayoutElementPropertiesPresenter)Mockito.verify((Object)this.elementPropertiesPresenter)).edit((LayoutElementWithProperties)this.container);
    }

    @Test
    public void testSelectorEntries() {
        this.presenter.edit(this.layoutEditor);
        this.presenter.getSearchService().search("", -1, results -> {
            Assert.assertEquals((long)results.size(), (long)8L);
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(0)).getKey(), (Object)"container");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(0)).getValue(), (Object)"page");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(1)).getKey(), (Object)"1");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(1)).getValue(), (Object)"row 1");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(2)).getKey(), (Object)"1");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(2)).getValue(), (Object)"row 1 > column 1 > component 1");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(3)).getKey(), (Object)"2");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(3)).getValue(), (Object)"row 1 > column 2 > component 1");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(4)).getKey(), (Object)"2");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(4)).getValue(), (Object)"row 2");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(5)).getKey(), (Object)"1");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(5)).getValue(), (Object)"row 2 > column 1 > component 1");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(6)).getKey(), (Object)"2");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(6)).getValue(), (Object)"row 2 > column 1 > component 2");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(7)).getKey(), (Object)"CPARTS");
            Assert.assertEquals((Object)((LiveSearchEntry)results.get(7)).getValue(), (Object)"row 2 > column 1 > component 3");
        });
    }

    @Test
    public void columnWithPartsTest() {
        this.presenter.edit(this.layoutEditor);
        this.presenter.edit((LayoutEditorElement)this.columnWithParts);
        ((LayoutEditorPropertiesPresenter.View)Mockito.verify((Object)this.view)).showParts(Arrays.asList("Root", this.PART_1.id, this.PART_2.id));
    }

    @Test
    public void columnWithoutPartsTest() {
        this.presenter.edit(this.layoutEditor);
        ((LayoutEditorPropertiesPresenter.View)Mockito.verify((Object)this.view)).noParts();
    }

    @Test
    public void partEditTest() {
        this.mockSelectedElement(this.columnWithParts.id);
        this.presenter.edit(this.layoutEditor);
        this.presenter.edit((LayoutEditorElement)this.columnWithParts);
        this.presenter.onPartSelected(this.PART_1.id);
        ((LayoutElementPropertiesPresenter)Mockito.verify((Object)this.elementPropertiesPresenter)).edit((LayoutElementWithProperties)this.PART_1);
    }

    @Test
    public void rootPartTest() {
        this.mockSelectedElement(this.columnWithParts.id);
        this.presenter.edit(this.layoutEditor);
        this.presenter.edit((LayoutEditorElement)this.columnWithParts);
        this.presenter.onPartSelected("Root");
        ((LayoutElementPropertiesPresenter)Mockito.verify((Object)this.elementPropertiesPresenter)).edit((LayoutElementWithProperties)this.columnWithParts);
    }

    private void mockSelectedElement(String id) {
        SingleLiveSearchSelectionHandler selectionHandler = (SingleLiveSearchSelectionHandler)Mockito.mock(SingleLiveSearchSelectionHandler.class);
        Mockito.when((Object)((String)selectionHandler.getSelectedKey())).thenReturn((Object)id);
        this.presenter.setSelectionHandler(selectionHandler);
    }

    private class LayoutElementTest
    implements LayoutEditorElement {
        private String id;
        private LayoutEditorElementType type;
        private LayoutEditorElement parent;
        private List<LayoutElementTest> children;
        private List<LayoutElementPartTest> parts;

        public LayoutElementTest(String id, LayoutEditorElementType type, List<LayoutElementTest> children) {
            this(id, type, children, new ArrayList<LayoutElementPartTest>());
        }

        public LayoutElementTest(String id, LayoutEditorElementType type, List<LayoutElementTest> children, List<LayoutElementPartTest> parts) {
            this.id = id;
            this.type = type;
            this.children = children;
            this.parts = parts;
            this.children.forEach(child -> {
                child.parent = this;
            });
            this.parts.forEach(p -> p.setParent(this));
        }

        public LayoutEditorElementType geElementType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public void setSelectable(boolean selectable) {
        }

        public boolean isSelected() {
            return false;
        }

        public void setSelected(boolean status) {
        }

        public Map<String, String> getProperties() {
            return null;
        }

        public void clearProperties() {
        }

        public void setProperty(String property, String value) {
        }

        public void removeProperty(String property) {
        }

        public List<PropertyEditorCategory> getPropertyCategories() {
            return null;
        }

        public LayoutEditorElement getParentElement() {
            return this.parent;
        }

        public List<? extends LayoutEditorElement> getChildElements() {
            return this.children;
        }

        public List<LayoutEditorElementPart> getLayoutEditorElementParts() {
            return this.parts.stream().map(p -> p).collect(Collectors.toList());
        }
    }

    private class LayoutElementPartTest
    implements LayoutEditorElementPart {
        private String id;
        private LayoutEditorElement parent;

        public LayoutElementPartTest(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, String> getProperties() {
            return null;
        }

        public void clearProperties() {
        }

        public void setProperty(String property, String value) {
        }

        public void removeProperty(String property) {
        }

        public List<PropertyEditorCategory> getPropertyCategories() {
            return null;
        }

        public void setSelected(boolean status) {
        }

        public LayoutEditorElement getParent() {
            return this.parent;
        }

        public void setParent(LayoutEditorElement parent) {
            this.parent = parent;
        }
    }
}

