/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client;

import java.util.function.Supplier;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.LayoutEditorPresenter;
import org.uberfire.ext.layout.editor.client.components.container.Container;
import org.uberfire.ext.layout.editor.client.generator.LayoutGenerator;
import org.uberfire.ext.layout.editor.client.widgets.LayoutDragComponentGroupPresenter;

@RunWith(value=MockitoJUnitRunner.class)
public class LayoutEditorPresenterTest {
    public static final String LAYOUT_NAME = "test layout";
    public static final String EMPTY_TITLE_TEXT = "Empty title text";
    public static final String EMPTY_SUB_TITLE_TEXT = "Empty SubTitle text";
    @Mock
    private Container container;
    @Mock
    private LayoutGenerator layoutGenerator;
    @Mock
    private LayoutEditorPresenter.View view;
    @Mock
    private LayoutDragComponentGroupPresenter.View dragComponentGroupView;
    private LayoutTemplate testTemplate = new LayoutTemplate("test layout");
    private LayoutEditorPresenter presenter;

    @Before
    public void initialize() {
        this.presenter = new LayoutEditorPresenter(this.view, this.container, this.layoutGenerator);
    }

    @Test
    public void testInitialization() {
        ((LayoutEditorPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        this.presenter.initNew();
        ((Container)Mockito.verify((Object)this.container)).getView();
        ((LayoutEditorPresenter.View)Mockito.verify((Object)this.view)).setupDesign((UberElement)ArgumentMatchers.any());
    }

    @Test
    public void testLoadLayout() {
        this.presenter.loadLayout(this.testTemplate, EMPTY_TITLE_TEXT, EMPTY_SUB_TITLE_TEXT);
        ((Container)Mockito.verify((Object)this.container)).load(this.testTemplate, EMPTY_TITLE_TEXT, EMPTY_SUB_TITLE_TEXT);
    }

    @Test
    public void testLoadEmptyLayout() {
        this.presenter.loadEmptyLayout(LAYOUT_NAME, EMPTY_TITLE_TEXT, EMPTY_SUB_TITLE_TEXT);
        ((Container)Mockito.verify((Object)this.container)).loadEmptyLayout(LAYOUT_NAME, LayoutTemplate.Style.FLUID, EMPTY_TITLE_TEXT, EMPTY_SUB_TITLE_TEXT);
    }

    @Test
    public void testSetup() {
        Supplier<Boolean> lockSupplier = () -> false;
        this.presenter.setup(lockSupplier);
        ((Container)Mockito.verify((Object)this.container)).setLockSupplier(lockSupplier);
    }

    public void testLayoutEditorClear() {
        this.presenter.clear();
        ((Container)Mockito.verify((Object)this.container)).reset();
    }
}

