/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.m2repo.preferences;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.annotation.Generated;

import org.uberfire.annotations.Customizable;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.bean.BasePreferenceBean;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.PreferenceBeanStore;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
@Generated("org.uberfire.ext.preferences.processors.WorkbenchPreferenceProcessor")
/*
* WARNING! This class is generated. Do not modify.
*/
public class ArtifactRepositoryPreferenceBeanGeneratedImpl extends ArtifactRepositoryPreference implements BasePreferenceBean<ArtifactRepositoryPreference> {

    private PreferenceBeanStore store;
    
    private PreferenceScopeResolutionStrategy resolutionStrategy;

    @Inject
    public ArtifactRepositoryPreferenceBeanGeneratedImpl( final PreferenceBeanStore store,
                               @Customizable final PreferenceScopeResolutionStrategy resolutionStrategy ) {
        this.store = store;
        this.resolutionStrategy = resolutionStrategy;
    }

    @Override
    public void load() {
        load( ( ParameterizedCommand<Throwable> ) null );
    }

    @Override
    public void load( final ParameterizedCommand<Throwable> errorCallback ) {
        load( ( ParameterizedCommand<ArtifactRepositoryPreference> ) null, errorCallback );
    }

    @Override
    public void load( final ParameterizedCommand<ArtifactRepositoryPreference> successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        final ArtifactRepositoryPreferenceBeanGeneratedImpl preferenceBean = this;

        store.load( new ArtifactRepositoryPreferencePortableGeneratedImpl(),
                    getLoadSuccessCallback( successCallback ),
                    errorCallback );
    }

    @Override
    public void load( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy ) {
        load( customScopeResolutionStrategy, null );
    }

    @Override
    public void load( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        load( customScopeResolutionStrategy, null, errorCallback );
    }

    @Override
    public void load( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final ParameterizedCommand<ArtifactRepositoryPreference> successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        final ArtifactRepositoryPreferenceBeanGeneratedImpl preferenceBean = this;

        store.load( new ArtifactRepositoryPreferencePortableGeneratedImpl(),
                    customScopeResolutionStrategy,
                    getLoadSuccessCallback( successCallback ),
                    errorCallback );
    }

    private ParameterizedCommand<BasePreferencePortable<ArtifactRepositoryPreference>> getLoadSuccessCallback( final ParameterizedCommand<ArtifactRepositoryPreference> successCallback ) {
        final ArtifactRepositoryPreferenceBeanGeneratedImpl preferenceBean = this;

        return new ParameterizedCommand<BasePreferencePortable<ArtifactRepositoryPreference>>() {
            @Override
            public void execute( final BasePreferencePortable<ArtifactRepositoryPreference> portablePreference ) {
                copy( (ArtifactRepositoryPreferencePortableGeneratedImpl) portablePreference, preferenceBean );
                if ( successCallback != null ) {
                    successCallback.execute( preferenceBean );
                }
            }
        };
    }

    private void copy( final ArtifactRepositoryPreference from,
                       final ArtifactRepositoryPreference to ) {
        to.setGlobalM2RepoDir( from.getGlobalM2RepoDir() );
        to.setGlobalM2RepoDirEnabled( from.isGlobalM2RepoDirEnabled() );
        to.setWorkspaceM2RepoDir( from.getWorkspaceM2RepoDir() );
        to.setWorkspaceM2RepoDirEnabled( from.isWorkspaceM2RepoDirEnabled() );
        to.setDistributionManagementM2RepoDirEnabled( from.isDistributionManagementM2RepoDirEnabled() );
    }

    @Override
    public void save() {
        save( ( ParameterizedCommand<Throwable> ) null );
    }

    @Override
    public void save( final ParameterizedCommand<Throwable> errorCallback ) {
        save( ( Command ) null, errorCallback );
    }

    @Override
    public void save( final Command successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        store.save( createPortableCopy(),
                    successCallback,
                    errorCallback );
    }

    @Override
    public void save( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy ) {
        save( customScopeResolutionStrategy, null );
    }

    @Override
    public void save( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        save( customScopeResolutionStrategy, null, errorCallback );
    }

    @Override
    public void save( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final Command successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        store.save( createPortableCopy(),
                    customScopeResolutionStrategy,
                    successCallback,
                    errorCallback );
    }

    @Override
    public void save( final PreferenceScope customScope ) {
        save( customScope, null );
    }

    @Override
    public void save( final PreferenceScope customScope,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        save( customScope, null, errorCallback );
    }

    @Override
    public void save( final PreferenceScope customScope,
                      final Command successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        store.save( createPortableCopy(),
                    customScope,
                    successCallback,
                    errorCallback );
    }

    private BasePreferencePortable<ArtifactRepositoryPreference> createPortableCopy() {
        ArtifactRepositoryPreferencePortableGeneratedImpl portablePreference = new ArtifactRepositoryPreferencePortableGeneratedImpl();

        copy( this, portablePreference );

        return portablePreference;
    }
}
