/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.util.Properties;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.FixNotMavenizedArtifactInfo;
import org.junit.Test;

public class FixNotMavenizedArtifactInfoTest {
    @Test
    public void testProperties() {
        FixNotMavenizedArtifactInfo fixNotMavenizedArtifactInfo = new FixNotMavenizedArtifactInfo();
        Properties result = fixNotMavenizedArtifactInfo.getProperties("/opt/wildfly/standalone/tmp/vfs/temp/temp9c869d5d938ad120/content-b548cc99838ba656/WEB-INF/lib/junit-4.12.jar");
        TestCase.assertFalse((boolean)result.isEmpty());
        Assertions.assertThat((String)result.getProperty("groupId")).isEqualTo((Object)"junit");
        Assertions.assertThat((String)result.getProperty("artifactId")).isEqualTo((Object)"junit");
        Assertions.assertThat((String)result.getProperty("version")).isEqualTo((Object)"4.12");
        result = fixNotMavenizedArtifactInfo.getProperties("/opt/wildfly/standalone/tmp/vfs/temp/temp9c869d5d938ad120/content-b548cc99838ba656/WEB-INF/lib/ant-launcher-X.12-SNAPSHOT.jar");
        TestCase.assertFalse((boolean)result.isEmpty());
        Assertions.assertThat((String)result.getProperty("groupId")).isEqualTo((Object)"org.apache.ant");
        Assertions.assertThat((String)result.getProperty("artifactId")).isEqualTo((Object)"ant-launcher");
        Assertions.assertThat((String)result.getProperty("version")).isEqualTo((Object)"X.12-SNAPSHOT");
        result = fixNotMavenizedArtifactInfo.getProperties("/opt/wildfly/standalone/tmp/vfs/temp/temp9c869d5d938ad120/content-b548cc99838ba656/WEB-INF/lib/ant-X.12-SNAPSHOT.jar");
        TestCase.assertFalse((boolean)result.isEmpty());
        Assertions.assertThat((String)result.getProperty("groupId")).isEqualTo((Object)"org.apache.ant");
        Assertions.assertThat((String)result.getProperty("artifactId")).isEqualTo((Object)"ant");
        Assertions.assertThat((String)result.getProperty("version")).isEqualTo((Object)"X.12-SNAPSHOT");
    }

    @Test
    public void testEmptyProperties() {
        FixNotMavenizedArtifactInfo fixNotMavenizedArtifactInfo = new FixNotMavenizedArtifactInfo();
        Properties result = fixNotMavenizedArtifactInfo.getProperties("/opt/wildfly/standalone/tmp/vfs/temp/temp9c869d5d938ad120/content-b548cc99838ba656/WEB-INF/lib/xxjunit-4.12.jar");
        TestCase.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testBuildPOM() {
        FixNotMavenizedArtifactInfo fixNotMavenizedArtifactInfo = new FixNotMavenizedArtifactInfo();
        GAV gav = new GAV("junit", "junit", "4.12");
        String pomResult = fixNotMavenizedArtifactInfo.buildPom(gav);
        Assertions.assertThat((String)pomResult).isEqualTo((Object)"<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>junit</groupId>\n  <artifactId>junit</artifactId>\n  <version>4.12</version>\n  <packaging>jar</packaging>\n</project>");
    }
}

