/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.appformer.maven.integration.Aether;
import org.assertj.core.api.Assertions;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.M2ServletContextListener;
import org.junit.After;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class M2ServletContextListenerTest {
    @After
    public void tearDown() throws Exception {
        this.deleteArtifactIFPresent();
        System.clearProperty("kie.maven.offline.force");
    }

    private void deleteArtifactIFPresent() throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(this.getArtifact());
        try {
            ArtifactResult result = Aether.getAether().getSystem().resolveArtifact(Aether.getAether().getSession(), artifactRequest);
            File artifactFile = result.getArtifact().getFile();
            Assertions.assertThat((boolean)artifactFile.delete()).isTrue();
        }
        catch (ArtifactResolutionException artifactResolutionException) {
            // empty catch block
        }
    }

    private Artifact getArtifact() {
        DefaultArtifact jarArtifact = new DefaultArtifact("org.uberfire", "uberfire-m2repo-editor-backend", "jar", "100-SNAPSHOT");
        return jarArtifact;
    }

    @Test
    public void deployJarsFrowWar() throws Exception {
        RepositorySystemSession session = Aether.getAether().getSession();
        Assertions.assertThat((boolean)this.checksIfArtifactIsPresent(session)).isFalse();
        File file = new File("target/test-classes/org/guvnor/m2repo/backend/server/uberfire-m2repo-editor-backend-100-SNAPSHOT.jar");
        Assertions.assertThat((File)file).exists();
        M2ServletContextListener listener = new M2ServletContextListener();
        GAV deployed = listener.deployJar(file.getAbsolutePath());
        Assertions.assertThat((String)deployed.getGroupId()).isEqualTo("org.uberfire");
        Assertions.assertThat((String)deployed.getArtifactId()).isEqualTo("uberfire-m2repo-editor-backend");
        Assertions.assertThat((String)deployed.getVersion()).isEqualTo("100-SNAPSHOT");
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(this.getArtifact());
        ArtifactResult result = Aether.getAether().getSystem().resolveArtifact(session, artifactRequest);
        Assertions.assertThat((boolean)result.isMissing()).isFalse();
        Assertions.assertThat((boolean)result.isResolved()).isTrue();
        String absolutePath = result.getArtifact().getFile().toString();
        String folder = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
        File remoteRepos = new File(folder + File.separator + "_remote.repositories");
        Assertions.assertThat((boolean)remoteRepos.exists()).isTrue();
        File metadata = new File(folder + File.separator + "maven-metadata-local.xml");
        Assertions.assertThat((boolean)metadata.exists()).isTrue();
        File pom = new File(folder + File.separator + "uberfire-m2repo-editor-backend-100-SNAPSHOT.pom");
        Assertions.assertThat((boolean)pom.exists()).isTrue();
    }

    @Test
    public void checkRegularExecution() {
        System.setProperty("kie.maven.offline.force", "false");
        M2ServletContextListener listener = (M2ServletContextListener)Mockito.spy((Object)new M2ServletContextListener());
        ServletContextEvent contextEvent = (ServletContextEvent)Mockito.mock(ServletContextEvent.class);
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getRealPath((String)Matchers.any())).thenReturn((Object)".");
        Mockito.when((Object)contextEvent.getServletContext()).thenReturn((Object)servletContext);
        listener.contextInitialized(contextEvent);
        ((M2ServletContextListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).deployJarsFromWar((String)Matchers.any());
    }

    @Test
    public void checkOfflineExecution() {
        System.setProperty("kie.maven.offline.force", "true");
        M2ServletContextListener listener = (M2ServletContextListener)Mockito.spy((Object)new M2ServletContextListener());
        ServletContextEvent contextEvent = (ServletContextEvent)Mockito.mock(ServletContextEvent.class);
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getRealPath((String)Matchers.any())).thenReturn((Object)".");
        Mockito.when((Object)contextEvent.getServletContext()).thenReturn((Object)servletContext);
        listener.contextInitialized(contextEvent);
        ((M2ServletContextListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).deployJarsFromWar((String)Matchers.any());
    }

    private boolean checksIfArtifactIsPresent(RepositorySystemSession session) {
        try {
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact(this.getArtifact());
            Aether.getAether().getSystem().resolveArtifact(session, artifactRequest);
            return true;
        }
        catch (ArtifactResolutionException e) {
            return false;
        }
    }
}

