/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.enterprise.inject.Instance;
import org.apache.commons.io.FileUtils;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.backend.server.M2RepoServiceImpl;
import org.guvnor.m2repo.backend.server.helpers.FormData;
import org.guvnor.m2repo.backend.server.helpers.HttpPostHelper;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepositoryProducer;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepositoryService;
import org.guvnor.m2repo.preferences.ArtifactRepositoryPreference;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.cdi.workspace.WorkspaceNameResolver;
import org.uberfire.mocks.MockInstanceImpl;

class M2RepoServiceCreator {
    private static final Logger log = LoggerFactory.getLogger(M2RepoServiceCreator.class);
    private GuvnorM2Repository repo;
    private M2RepoServiceImpl service;
    private HttpPostHelper helper;
    private Method helperMethod;

    public GuvnorM2Repository getRepo() {
        return this.repo;
    }

    public M2RepoServiceImpl getService() {
        return this.service;
    }

    public HttpPostHelper getHelper() {
        return this.helper;
    }

    public Method getHelperMethod() {
        return this.helperMethod;
    }

    M2RepoServiceCreator() throws Exception {
        log.info("Deleting existing Repositories instance..");
        File dir = new File("repositories");
        log.info("DELETING test repo: " + dir.getAbsolutePath());
        M2RepoServiceCreator.deleteDir(dir);
        log.info("TEST repo was deleted.");
        ArtifactRepositoryPreference pref = (ArtifactRepositoryPreference)Mockito.mock(ArtifactRepositoryPreference.class);
        Mockito.when((Object)pref.getGlobalM2RepoDir()).thenReturn((Object)"repositories/kie");
        Mockito.when((Object)pref.isGlobalM2RepoDirEnabled()).thenReturn((Object)true);
        Mockito.when((Object)pref.isDistributionManagementM2RepoDirEnabled()).thenReturn((Object)true);
        Mockito.when((Object)pref.isWorkspaceM2RepoDirEnabled()).thenReturn((Object)false);
        WorkspaceNameResolver resolver = (WorkspaceNameResolver)Mockito.mock(WorkspaceNameResolver.class);
        Mockito.when((Object)resolver.getWorkspaceName()).thenReturn((Object)"global");
        ArtifactRepositoryProducer producer = new ArtifactRepositoryProducer(pref, resolver);
        producer.initialize();
        MockInstanceImpl repositories = new MockInstanceImpl((Object[])new ArtifactRepository[]{producer.produceLocalRepository(), producer.produceGlobalRepository(), producer.produceDistributionManagementRepository()});
        ArtifactRepositoryService factory = new ArtifactRepositoryService((Instance)repositories);
        this.repo = new GuvnorM2Repository(factory);
        this.repo.init();
        this.service = new M2RepoServiceImpl((Logger)Mockito.mock(Logger.class), this.repo);
        Field repositoryField = M2RepoServiceImpl.class.getDeclaredField("repository");
        repositoryField.setAccessible(true);
        repositoryField.set(this.service, this.repo);
        this.helper = new HttpPostHelper();
        this.helperMethod = HttpPostHelper.class.getDeclaredMethod("upload", FormData.class);
        this.helperMethod.setAccessible(true);
        Field m2RepoServiceField = HttpPostHelper.class.getDeclaredField("m2RepoService");
        m2RepoServiceField.setAccessible(true);
        m2RepoServiceField.set(this.helper, this.service);
    }

    static boolean deleteDir(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (Exception e) {
            log.error("Couldn't delete file {}", (Object)dir);
            log.error(e.getMessage(), (Throwable)e);
        }
        return dir.delete();
    }
}

