/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.appformer.maven.integration.Aether;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepositoryProducer;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepositoryService;
import org.guvnor.m2repo.preferences.ArtifactRepositoryPreference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.cdi.workspace.WorkspaceNameResolver;
import org.uberfire.mocks.MockInstanceImpl;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Aether.class})
@PowerMockIgnore(value={"javax.crypto.*", "javax.net.ssl.*", "javax.net.*", "javax.security.auth.x500.X500Principal"})
public class GuvnorM2RepositoryTest {
    public static final String KIE_SETTINGS_CUSTOM_KEY = "kie.maven.settings.custom";
    public static final String SETTINGS_SECURITY_KEY = "settings.security";
    private static final Logger log = LoggerFactory.getLogger(GuvnorM2RepositoryTest.class);
    private static String settingsSecurityOriginalValue;
    private static String kieSettingsCustomOriginalValue;
    private GuvnorM2Repository repo;
    private RepositorySystem repositorySystem = (RepositorySystem)Mockito.mock(RepositorySystem.class);
    private RepositorySystemSession repositorySystemSession = (RepositorySystemSession)Mockito.mock(RepositorySystemSession.class);
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void setupClass() throws IOException, URISyntaxException {
        settingsSecurityOriginalValue = System.getProperty(SETTINGS_SECURITY_KEY);
        System.setProperty(SETTINGS_SECURITY_KEY, GuvnorM2RepositoryTest.resolveFilePath("settings-security.xml"));
        kieSettingsCustomOriginalValue = System.getProperty(KIE_SETTINGS_CUSTOM_KEY);
        System.setProperty(KIE_SETTINGS_CUSTOM_KEY, GuvnorM2RepositoryTest.resolveFilePath("settings.xml"));
    }

    private static String resolveFilePath(String value) throws URISyntaxException {
        URL url = GuvnorM2RepositoryTest.class.getResource(value);
        URI uri = url.toURI();
        File f = new File(uri);
        return f.getAbsolutePath();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        GuvnorM2RepositoryTest.nullSafeSetProperty(SETTINGS_SECURITY_KEY, settingsSecurityOriginalValue);
        GuvnorM2RepositoryTest.nullSafeSetProperty(KIE_SETTINGS_CUSTOM_KEY, kieSettingsCustomOriginalValue);
    }

    private static void nullSafeSetProperty(String propertyKey, String propertyValue) {
        System.setProperty(propertyKey, propertyValue == null ? "" : propertyValue);
    }

    @Before
    public void setup() throws Exception {
        log.info("Deleting existing Repositories instance..");
        ArtifactRepositoryPreference pref = (ArtifactRepositoryPreference)Mockito.mock(ArtifactRepositoryPreference.class);
        Mockito.when((Object)pref.getGlobalM2RepoDir()).thenReturn((Object)"repositories/kie");
        Mockito.when((Object)pref.isGlobalM2RepoDirEnabled()).thenReturn((Object)true);
        Mockito.when((Object)pref.isDistributionManagementM2RepoDirEnabled()).thenReturn((Object)true);
        Mockito.when((Object)pref.isWorkspaceM2RepoDirEnabled()).thenReturn((Object)false);
        WorkspaceNameResolver resolver = (WorkspaceNameResolver)Mockito.mock(WorkspaceNameResolver.class);
        Mockito.when((Object)resolver.getWorkspaceName()).thenReturn((Object)"global");
        ArtifactRepositoryProducer producer = new ArtifactRepositoryProducer(pref, resolver);
        producer.initialize();
        MockInstanceImpl repositories = new MockInstanceImpl((Object[])new ArtifactRepository[]{producer.produceLocalRepository(), producer.produceGlobalRepository(), producer.produceDistributionManagementRepository()});
        ArtifactRepositoryService factory = new ArtifactRepositoryService((Instance)repositories);
        this.repo = new GuvnorM2Repository(factory);
        this.repo.init();
        Aether aether = (Aether)Mockito.mock(Aether.class);
        Mockito.when((Object)aether.getSession()).thenReturn((Object)this.repositorySystemSession);
        Mockito.when((Object)aether.getSystem()).thenReturn((Object)this.repositorySystem);
        PowerMockito.mockStatic(Aether.class, (Class[])new Class[0]);
        Mockito.when((Object)Aether.getAether()).thenReturn((Object)aether);
        try {
            Mockito.when((Object)this.repositorySystem.install((RepositorySystemSession)Matchers.any(RepositorySystemSession.class), (InstallRequest)Matchers.any(InstallRequest.class))).thenAnswer((Answer)new Answer<InstallResult>(){

                public InstallResult answer(InvocationOnMock invocation) throws Throwable {
                    return new InstallResult((InstallRequest)invocation.getArguments()[1]);
                }
            });
        }
        catch (InstallationException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDeployArtifactWithDeployArtifactDistributionManagement() throws Exception {
        GAV gav = new GAV("org.kie.guvnor", "guvnor-m2repo-editor-backend", "0.0.1-SNAPSHOT");
        InputStream is = this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-with-distribution-management.jar");
        this.repo.deployArtifact(is, gav, true);
        ((RepositorySystem)Mockito.verify((Object)this.repositorySystem, (VerificationMode)Mockito.times((int)1))).deploy((RepositorySystemSession)Matchers.any(RepositorySystemSession.class), (DeployRequest)Matchers.argThat(request -> "global-m2-repo".equals(request.getRepository().getId())));
        ((RepositorySystem)Mockito.verify((Object)this.repositorySystem, (VerificationMode)Mockito.times((int)1))).deploy((RepositorySystemSession)Matchers.any(RepositorySystemSession.class), (DeployRequest)Matchers.argThat(request -> {
            String string = "example.project.http";
            RemoteRepository repo = request.getRepository();
            boolean equals = string.equals(repo.getId());
            if (!equals) {
                return false;
            }
            Authentication auth = repo.getAuthentication();
            Class<?> class1 = auth.getClass();
            try {
                Field declaredField = class1.getDeclaredField("authentications");
                declaredField.setAccessible(true);
                Authentication[] object = (Authentication[])declaredField.get(auth);
                Authentication authentication = object[1];
                Class<?> class2 = authentication.getClass();
                boolean equals3 = "SecretAuthentication".equals(class2.getSimpleName());
                if (equals3) {
                    Field valueField = class2.getDeclaredField("value");
                    valueField.setAccessible(true);
                    Assert.assertEquals((String)"Plaintext pw (repopw) length expected.", (long)6L, (long)((char[])valueField.get(authentication)).length);
                }
                return "StringAuthentication".equals(object[0].getClass().getSimpleName()) && equals3;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }));
    }

    @Test
    public void testDeployArtifactFilteredOutAllRepositories() throws Exception {
        GAV gav = new GAV("org.kie.guvnor", "guvnor-m2repo-editor-backend", "0.0.1-SNAPSHOT");
        InputStream is = this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-with-distribution-management.jar");
        this.repo.deployArtifact(is, gav, true, repo -> false);
        ((RepositorySystem)Mockito.verify((Object)this.repositorySystem, (VerificationMode)Mockito.never())).deploy((RepositorySystemSession)Matchers.any(RepositorySystemSession.class), (DeployRequest)Matchers.any());
    }

    @Test
    public void testContainArtifact() throws Exception {
        GAV gav = new GAV("org.kie.guvnor", "guvnor-m2repo-editor-backend", "0.0.1-SNAPSHOT");
        this.repo.containsArtifact(gav);
        ((RepositorySystem)Mockito.verify((Object)this.repositorySystem, (VerificationMode)Mockito.times((int)1))).resolveArtifact((RepositorySystemSession)Matchers.any(), (ArtifactRequest)Matchers.any());
    }

    @Test
    public void testContainArtifactFilteredOutAllRepositories() throws Exception {
        GAV gav = new GAV("org.kie.guvnor", "guvnor-m2repo-editor-backend", "0.0.1-SNAPSHOT");
        this.repo.containsArtifact(gav, repo -> false);
        ((RepositorySystem)Mockito.verify((Object)this.repositorySystem, (VerificationMode)Mockito.never())).resolveArtifact((RepositorySystemSession)Matchers.any(), (ArtifactRequest)Matchers.any());
    }

    @Test
    public void testListFilesWithoutParameters() {
        ArrayList<String> wildcards = new ArrayList<String>();
        wildcards.add("*.jar");
        wildcards.add("*.kjar");
        wildcards.add("*.pom");
        GuvnorM2Repository spiedRepo = (GuvnorM2Repository)Mockito.spy((Object)this.repo);
        ((GuvnorM2Repository)Mockito.doReturn(new ArrayList()).when((Object)spiedRepo)).getFiles((List)Matchers.any());
        spiedRepo.listFiles();
        ((GuvnorM2Repository)Mockito.verify((Object)spiedRepo)).getFiles(wildcards);
    }

    @Test
    public void testListFilesWithFilter() {
        String filter = "filter";
        ArrayList<String> wildcards = new ArrayList<String>();
        wildcards.add("*filter*.jar");
        wildcards.add("*filter*.kjar");
        wildcards.add("*filter*.pom");
        GuvnorM2Repository spiedRepo = (GuvnorM2Repository)Mockito.spy((Object)this.repo);
        ((GuvnorM2Repository)Mockito.doReturn(new ArrayList()).when((Object)spiedRepo)).getFiles((List)Matchers.any());
        spiedRepo.listFiles("filter");
        ((GuvnorM2Repository)Mockito.verify((Object)spiedRepo)).getFiles(wildcards);
    }

    @Test
    public void testListFilesWithFilterAndFileFormats() {
        String filter = "filter";
        ArrayList<String> fileFormats = new ArrayList<String>();
        fileFormats.add("xml");
        fileFormats.add("war");
        ArrayList<String> wildcards = new ArrayList<String>();
        wildcards.add("*filter*.xml");
        wildcards.add("*filter*.war");
        GuvnorM2Repository spiedRepo = (GuvnorM2Repository)Mockito.spy((Object)this.repo);
        ((GuvnorM2Repository)Mockito.doReturn(new ArrayList()).when((Object)spiedRepo)).getFiles((List)Matchers.any());
        spiedRepo.listFiles("filter", fileFormats);
        ((GuvnorM2Repository)Mockito.verify((Object)spiedRepo)).getFiles(wildcards);
    }

    @Test
    public void testGetPomTextVerifiesPath() {
        this.repo.getPomText("dir/name.pom");
        this.repo.getPomText("dir/name.kjar");
        this.repo.getPomText("dir/name.jar");
        this.exception.expect(RuntimeException.class);
        this.repo.getPomText("dir/name.foo");
    }

    @Test
    public void testLoadFileTextFromJar() {
        File jarFile = new File("src/test/resources/org/guvnor/m2repo/backend/server/evaluation-12.1.1.jar");
        Assert.assertNotNull((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", (String)"kie-deployment-descriptor.xml"));
        Assert.assertNotNull((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", (String)"kmodule.xml"));
        Assert.assertNull((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", (String)"kie-descriptor.xml"));
        Assert.assertNull((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", (String)"modu.xml"));
        Assert.assertNull((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", (String)""));
        Assert.assertNull((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", (String)""));
        Assert.assertNull((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", null));
        Assert.assertNull((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", null));
    }
}

