/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import javax.enterprise.inject.Instance;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.backend.server.M2RepoServiceImpl;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepositoryProducer;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepositoryService;
import org.guvnor.m2repo.preferences.ArtifactRepositoryPreference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.uberfire.backend.server.cdi.workspace.WorkspaceNameResolver;
import org.uberfire.mocks.MockInstanceImpl;

public class JarPathTest {
    private GuvnorM2Repository repository;

    @Before
    public void setupGuvnorM2Repository() {
        ArtifactRepositoryPreference pref = (ArtifactRepositoryPreference)Mockito.mock(ArtifactRepositoryPreference.class);
        Mockito.when((Object)pref.getGlobalM2RepoDir()).thenReturn((Object)"repositories/kie");
        Mockito.when((Object)pref.isGlobalM2RepoDirEnabled()).thenReturn((Object)true);
        Mockito.when((Object)pref.isDistributionManagementM2RepoDirEnabled()).thenReturn((Object)true);
        Mockito.when((Object)pref.isWorkspaceM2RepoDirEnabled()).thenReturn((Object)false);
        WorkspaceNameResolver resolver = (WorkspaceNameResolver)Mockito.mock(WorkspaceNameResolver.class);
        Mockito.when((Object)resolver.getWorkspaceName()).thenReturn((Object)"global");
        ArtifactRepositoryProducer producer = new ArtifactRepositoryProducer(pref, resolver);
        producer.initialize();
        MockInstanceImpl repositories = new MockInstanceImpl((Object[])new ArtifactRepository[]{producer.produceLocalRepository(), producer.produceGlobalRepository(), producer.produceDistributionManagementRepository()});
        ArtifactRepositoryService factory = new ArtifactRepositoryService((Instance)repositories);
        this.repository = new GuvnorM2Repository(factory);
        this.repository.init();
    }

    @Test
    public void testLinuxPathSeparators() {
        M2RepoServiceImpl service = new M2RepoServiceImpl((Logger)Mockito.mock(Logger.class), this.repository);
        String jarPath = service.getJarPath(this.repository.getM2RepositoryDir("global-m2-repo") + "/a/b/c", "/");
        Assert.assertEquals((Object)"a/b/c", (Object)jarPath);
    }

    @Test
    public void testWindowsPathSeparators() {
        M2RepoServiceImpl service = new M2RepoServiceImpl((Logger)Mockito.mock(Logger.class), this.repository);
        String jarPath = service.getJarPath(this.repository.getM2RepositoryDir("global-m2-repo") + "\\a\\b\\c", "\\");
        Assert.assertEquals((Object)"a/b/c", (Object)jarPath);
    }
}

