/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.backend.server.M2RepoServiceImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.Logger;

@RunWith(value=MockitoJUnitRunner.class)
public class M2RepoServiceImplM2RepoURLTest {
    @Mock
    private GuvnorM2Repository repository;
    @Mock
    private Logger logger;
    private M2RepoServiceImpl m2RepoService;

    @Before
    public void setUp() throws Exception {
        this.m2RepoService = new M2RepoServiceImpl(this.logger, this.repository);
        ((GuvnorM2Repository)Mockito.doReturn((Object)"file://path-to-m2").when((Object)this.repository)).getRepositoryURL("global-m2-repo");
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("org.appformer.m2repo.url");
    }

    @Test
    public void errorDisplayedWhenPropertyIsNotSet() throws Exception {
        ((Logger)Mockito.verify((Object)this.logger)).error(ArgumentMatchers.anyString());
    }

    @Test
    public void localRepoURL() throws Exception {
        Assert.assertEquals((Object)"file://path-to-m2", (Object)this.m2RepoService.getRepositoryURL());
    }

    @Test
    public void repoURLFromSystemProperty() throws Exception {
        System.setProperty("org.appformer.m2repo.url", "http://my-url");
        Assert.assertEquals((Object)"http://my-url", (Object)this.m2RepoService.getRepositoryURL());
    }

    @Test
    public void repoURLFromSystemPropertyEmptyValue() throws Exception {
        Mockito.reset((Object[])new Logger[]{this.logger});
        System.setProperty("org.appformer.m2repo.url", "");
        Assert.assertEquals((Object)"file://path-to-m2", (Object)this.m2RepoService.getRepositoryURL());
        ((Logger)Mockito.verify((Object)this.logger)).warn(ArgumentMatchers.anyString());
    }

    @Test
    public void repoURLFromSystemPropertyInvalidURL() throws Exception {
        Mockito.reset((Object[])new Logger[]{this.logger});
        System.setProperty("org.appformer.m2repo.url", "12345");
        Assert.assertEquals((Object)"file://path-to-m2", (Object)this.m2RepoService.getRepositoryURL());
        ((Logger)Mockito.verify((Object)this.logger)).warn(ArgumentMatchers.anyString());
    }

    @Test
    public void testGetKModuleAndKieDeploymentDescriptorText() throws Exception {
        File jarFile = new File("src/test/resources/org/guvnor/m2repo/backend/server/evaluation-12.1.1.jar");
        Mockito.when((Object)this.repository.getKieDeploymentDescriptorText("evaluation-12.1.1.jar")).thenReturn((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", (String)"kie-deployment-descriptor.xml"));
        Mockito.when((Object)this.repository.getKModuleText("evaluation-12.1.1.jar")).thenReturn((Object)GuvnorM2Repository.loadFileTextFromJar((File)jarFile, (String)"META-INF", (String)"kmodule.xml"));
        Assert.assertNotNull((Object)this.m2RepoService.getKModuleText("evaluation-12.1.1.jar"));
        Assert.assertNotNull((Object)this.m2RepoService.getKieDeploymentDescriptorText("evaluation-12.1.1.jar"));
    }
}

