/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.client.upload;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.guvnor.m2repo.client.resources.i18n.M2RepoEditorConstants;
import org.guvnor.m2repo.client.upload.UploadFormView;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.gwtbootstrap3.client.ui.constants.FormType;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.FileUpload;
import org.uberfire.ext.widgets.common.client.common.FormStyleItem;
import org.uberfire.ext.widgets.common.client.common.FormStyleLayout;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

public class UploadFormViewImpl
extends BaseModal
implements UploadFormView {
    private FormStyleLayout form = new FormStyleLayout();
    private final TextBox hiddenGroupIdField = (TextBox)GWT.create(TextBox.class);
    private final TextBox hiddenArtifactIdField = (TextBox)GWT.create(TextBox.class);
    private final TextBox hiddenVersionIdField = (TextBox)GWT.create(TextBox.class);
    private FormStyleItem groupIdItem;
    private FormStyleItem artifactIdItem;
    private FormStyleItem versionIdItem;
    private UploadFormView.Presenter presenter;
    protected FileUpload uploader;

    public UploadFormViewImpl() {
        this.setTitle(M2RepoEditorConstants.INSTANCE.ArtifactUpload());
        this.setBody((Widget)this.doUploadForm());
        this.add((Widget)new ModalFooter(){
            {
                this.add((Widget)new Button(M2RepoEditorConstants.INSTANCE.Cancel()){
                    {
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                UploadFormViewImpl.this.hide();
                            }
                        });
                    }
                });
            }
        });
    }

    private Form doUploadForm() {
        this.form.setAction(this.getWebContext() + "/maven2");
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        this.form.setType(FormType.HORIZONTAL);
        this.form.addSubmitCompleteHandler(new AbstractForm.SubmitCompleteHandler(){

            public void onSubmitComplete(AbstractForm.SubmitCompleteEvent event) {
                UploadFormViewImpl.this.presenter.handleSubmitComplete(event);
            }
        });
        this.uploader = new FileUpload(() -> {
            if (this.presenter.isFileNameValid()) {
                this.form.submit();
            }
        });
        this.uploader.setName("fileUploadElement");
        this.hiddenGroupIdField.setName("groupId");
        this.hiddenArtifactIdField.setName("artifactId");
        this.hiddenVersionIdField.setName("version");
        this.form.addAttribute("File", (IsWidget)this.uploader);
        this.groupIdItem = this.form.addAttribute("Group IDENTIFIER", (IsWidget)this.hiddenGroupIdField);
        this.artifactIdItem = this.form.addAttribute("Artifact IDENTIFIER", (IsWidget)this.hiddenArtifactIdField);
        this.versionIdItem = this.form.addAttribute("Version IDENTIFIER", (IsWidget)this.hiddenVersionIdField);
        this.hideGAVInputs();
        return this.form;
    }

    private String getWebContext() {
        String context = GWT.getModuleBaseURL().replace(GWT.getModuleName() + "/", "");
        if (context.endsWith("/")) {
            context = context.substring(0, context.length() - 1);
        }
        return context;
    }

    public void init(UploadFormView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showUploadingBusy() {
        BusyPopup.showMessage((String)M2RepoEditorConstants.INSTANCE.Uploading());
    }

    @Override
    public void hideUploadingBusy() {
        BusyPopup.close();
    }

    @Override
    public void showSelectFileUploadWarning() {
        this.showMessage(M2RepoEditorConstants.INSTANCE.SelectFileUpload());
    }

    @Override
    public void showUnsupportedFileTypeWarning() {
        this.showMessage(M2RepoEditorConstants.INSTANCE.UnsupportedFileType());
    }

    @Override
    public void showUploadedSuccessfullyMessage() {
        this.showMessage(M2RepoEditorConstants.INSTANCE.UploadedSuccessfully());
    }

    @Override
    public void showInvalidJarNoPomWarning() {
        this.showMessage(M2RepoEditorConstants.INSTANCE.InvalidJarNotPom());
    }

    @Override
    public void showInvalidPomWarning() {
        this.showMessage(M2RepoEditorConstants.INSTANCE.InvalidPom());
    }

    @Override
    public void showUploadFailedError(String message) {
        this.showErrorMessage(M2RepoEditorConstants.INSTANCE.UploadFailed() + message);
    }

    @Override
    public void showGAVInputs() {
        this.hiddenArtifactIdField.setVisible(true);
        this.hiddenGroupIdField.setVisible(true);
        this.hiddenVersionIdField.setVisible(true);
        this.toggleFormStyleItem(this.groupIdItem, true);
        this.toggleFormStyleItem(this.artifactIdItem, true);
        this.toggleFormStyleItem(this.versionIdItem, true);
    }

    @Override
    public void hideGAVInputs() {
        this.toggleFormStyleItem(this.groupIdItem, false);
        this.toggleFormStyleItem(this.artifactIdItem, false);
        this.toggleFormStyleItem(this.versionIdItem, false);
        this.hideTextBox(this.hiddenArtifactIdField);
        this.hideTextBox(this.hiddenGroupIdField);
        this.hideTextBox(this.hiddenVersionIdField);
    }

    private void toggleFormStyleItem(FormStyleItem item, boolean toggle) {
        if (item != null) {
            item.setVisible(toggle);
        }
    }

    private void hideTextBox(TextBox textBox) {
        textBox.setText(null);
        textBox.setVisible(false);
    }

    @Override
    public String getFileName() {
        return this.uploader.getFilename();
    }

    private void showMessage(String message) {
        Window.alert((String)message);
    }

    private void showErrorMessage(String message) {
        ErrorPopup.showMessage((String)message);
    }
}

