/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.guvnor.m2repo.client.M2RepoEditorPresenter;
import org.guvnor.m2repo.client.event.M2RepoRefreshEvent;
import org.guvnor.m2repo.client.upload.UploadFormPresenter;
import org.gwtbootstrap3.client.ui.Button;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuItemCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class M2RepoEditorPresenterTest {
    @Mock
    UploadFormPresenter uploadFormPresenter;
    @Spy
    Event<M2RepoRefreshEvent> refreshEvents = new EventSourceMock();
    @GwtMock
    Button menuRefreshButton;
    ClickHandler clickHandler;
    @InjectMocks
    M2RepoEditorPresenter presenter;

    @Before
    public void setup() {
        ((Event)Mockito.doNothing().when(this.refreshEvents)).fire(Mockito.any(M2RepoRefreshEvent.class));
    }

    @Test
    public void testUpload() {
        this.presenter.getMenus(menus -> {
            MenuItemCommand upload = (MenuItemCommand)menus.getItems().get(0);
            upload.getCommand().execute();
            ((UploadFormPresenter)Mockito.verify((Object)this.uploadFormPresenter)).showView();
        });
    }

    @Test
    public void testRefresh() {
        Mockito.when((Object)this.menuRefreshButton.addClickHandler((ClickHandler)Mockito.any(ClickHandler.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                M2RepoEditorPresenterTest.this.clickHandler = (ClickHandler)aInvocation.getArguments()[0];
                return null;
            }
        });
        this.presenter.getMenus(menus -> {
            MenuCustom refresh = (MenuCustom)menus.getItems().get(1);
            refresh.build();
            this.clickHandler.onClick(new ClickEvent(){});
            ((Event)Mockito.verify(this.refreshEvents)).fire(Mockito.any(M2RepoRefreshEvent.class));
        });
    }
}

