/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.client.upload;

import javax.enterprise.event.Event;
import org.guvnor.m2repo.client.event.M2RepoSearchEvent;
import org.guvnor.m2repo.client.upload.UploadFormPresenter;
import org.guvnor.m2repo.client.upload.UploadFormView;
import org.gwtbootstrap3.client.shared.event.ModalHideEvent;
import org.gwtbootstrap3.client.shared.event.ModalHideHandler;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class UploadFormTest {
    @Mock
    private UploadFormView view;
    @Mock
    private Event<M2RepoSearchEvent> searchEvent;
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private AbstractForm.SubmitCompleteEvent submitCompleteEvent;
    @Mock
    private ModalHideEvent hideEvent;
    @Captor
    private ArgumentCaptor<ModalHideHandler> captor;
    private UploadFormPresenter uploadFormPresenter;

    @Before
    public void before() {
        this.uploadFormPresenter = new UploadFormPresenter(this.view, this.searchEvent, this.iocManager);
        ((UploadFormView)Mockito.verify((Object)this.view)).addHideHandler((ModalHideHandler)this.captor.capture());
    }

    @Test
    public void emptyFilenameTest() {
        Mockito.when((Object)this.view.getFileName()).thenReturn(null);
        this.uploadFormPresenter.isFileNameValid();
        ((UploadFormView)Mockito.verify((Object)this.view)).showSelectFileUploadWarning();
        ((UploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showUploadingBusy();
    }

    @Test
    public void nullFilenameTest() {
        Mockito.when((Object)this.view.getFileName()).thenReturn((Object)"");
        this.uploadFormPresenter.isFileNameValid();
        ((UploadFormView)Mockito.verify((Object)this.view)).showSelectFileUploadWarning();
        ((UploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showUploadingBusy();
    }

    @Test
    public void unsupportedFilenameTest() {
        Mockito.when((Object)this.view.getFileName()).thenReturn((Object)"//!#@%^&*()\\23\\(0");
        this.uploadFormPresenter.isFileNameValid();
        ((UploadFormView)Mockito.verify((Object)this.view)).showUnsupportedFileTypeWarning();
        ((UploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showUploadingBusy();
    }

    @Test
    public void correctFilenameTest() {
        Mockito.when((Object)this.view.getFileName()).thenReturn((Object)"/home/user/something/pom.xml");
        this.uploadFormPresenter.isFileNameValid();
        ((UploadFormView)Mockito.verify((Object)this.view)).showUploadingBusy();
    }

    @Test
    public void uploadOkSubmitHandlerTest() {
        Mockito.when((Object)this.submitCompleteEvent.getResults()).thenReturn((Object)"OK");
        this.uploadFormPresenter.handleSubmitComplete(this.submitCompleteEvent);
        ((UploadFormView)Mockito.verify((Object)this.view)).hideUploadingBusy();
        ((UploadFormView)Mockito.verify((Object)this.view)).hideUploadingBusy();
        ((UploadFormView)Mockito.verify((Object)this.view)).hideGAVInputs();
        ((UploadFormView)Mockito.verify((Object)this.view)).showUploadedSuccessfullyMessage();
    }

    @Test
    public void uploadMissingPomSubmitHandlerTest() {
        Mockito.when((Object)this.submitCompleteEvent.getResults()).thenReturn((Object)"MISSING_POM");
        this.uploadFormPresenter.handleSubmitComplete(this.submitCompleteEvent);
        ((UploadFormView)Mockito.verify((Object)this.view)).hideUploadingBusy();
        ((UploadFormView)Mockito.verify((Object)this.view)).showGAVInputs();
        ((UploadFormView)Mockito.verify((Object)this.view)).showInvalidJarNoPomWarning();
    }

    @Test
    public void uploadUnableToParsePomSubmitHandlerTest() {
        Mockito.when((Object)this.submitCompleteEvent.getResults()).thenReturn((Object)"UNABLE_TO_PARSE_POM");
        this.uploadFormPresenter.handleSubmitComplete(this.submitCompleteEvent);
        ((UploadFormView)Mockito.verify((Object)this.view)).hideUploadingBusy();
        ((UploadFormView)Mockito.verify((Object)this.view)).hide();
        ((UploadFormView)Mockito.verify((Object)this.view)).showInvalidPomWarning();
    }

    @Test
    public void uploadUnknownErrorTest() {
        String errorText = "Some unknown error text.";
        Mockito.when((Object)this.submitCompleteEvent.getResults()).thenReturn((Object)errorText);
        this.uploadFormPresenter.handleSubmitComplete(this.submitCompleteEvent);
        ((UploadFormView)Mockito.verify((Object)this.view)).hideUploadingBusy();
        this.view.hideGAVInputs();
        this.view.hide();
        this.view.showUploadFailedError(errorText);
    }

    @Test
    public void isViewDestroyedDuringHidingTest() {
        ModalHideHandler hideHandler = (ModalHideHandler)this.captor.getValue();
        hideHandler.onHide(this.hideEvent);
        ((SyncBeanManager)Mockito.verify((Object)this.iocManager)).destroyBean((Object)this.uploadFormPresenter);
    }
}

