/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.client.widgets;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import javax.enterprise.event.Event;
import org.guvnor.m2repo.client.widgets.ArtifactListPresenterImpl;
import org.guvnor.m2repo.client.widgets.ArtifactListView;
import org.guvnor.m2repo.client.widgets.ColumnType;
import org.guvnor.m2repo.model.JarListPageRequest;
import org.guvnor.m2repo.model.JarListPageRow;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class ArtifactListTest {
    private static final int REQUEST_RANGE_LENGTH = 53;
    private static final int REQUEST_RANGE_START = 19;
    private final boolean REQUEST_SORT_ORDER = true;
    private final String REQUEST_SORT_COLUMN = "C";
    private static final boolean RESPONSE_EXACT_ROWS = true;
    private static final int RESPONSE_ROWS_COUNT = 61;
    private static final String POM_TEXT = "POM text";
    @Mock
    private Event<NotificationEvent> event;
    @Mock
    private M2RepoService m2service;
    @Mock
    private PageResponse<JarListPageRow> response;
    @Mock
    private ArtifactListView view;
    @Mock
    private HasData<JarListPageRow> table;
    @Mock
    private Range range;
    @Mock
    private Column column;
    @Mock
    private ColumnSortList sortList;
    @Mock
    private ColumnSortList.ColumnSortInfo sortInfo;
    @Captor
    private ArgumentCaptor<JarListPageRequest> request;

    @Before
    public void setUp() {
        Mockito.when((Object)this.m2service.listArtifacts((JarListPageRequest)ArgumentMatchers.any(JarListPageRequest.class))).thenReturn(this.response);
        Mockito.when((Object)this.m2service.getPomText(Mockito.anyString())).thenReturn((Object)POM_TEXT);
        Mockito.when((Object)this.response.getTotalRowSize()).thenReturn((Object)61);
        Mockito.when((Object)this.response.isTotalRowSizeExact()).thenReturn((Object)true);
        Mockito.when((Object)this.view.getDisplay()).thenReturn(this.table);
        Mockito.when((Object)this.table.getVisibleRange()).thenReturn((Object)this.range);
        Mockito.when((Object)this.range.getStart()).thenReturn((Object)19);
        Mockito.when((Object)this.range.getLength()).thenReturn((Object)53);
        Mockito.when((Object)this.view.getColumnSortList()).thenReturn((Object)this.sortList);
        Mockito.when((Object)this.sortList.size()).thenReturn((Object)1);
        Mockito.when((Object)this.sortList.get(0)).thenReturn((Object)this.sortInfo);
        Mockito.when((Object)this.sortInfo.isAscending()).thenReturn((Object)true);
        Mockito.when((Object)this.sortInfo.getColumn()).thenReturn((Object)this.column);
        Mockito.when((Object)this.column.getDataStoreName()).thenReturn((Object)"C");
    }

    @Test
    public void testSearch() {
        ArtifactListPresenterImpl.RefreshableAsyncDataProvider dataProvider;
        ArtifactListPresenterImpl presenter = new ArtifactListPresenterImpl(this.view, (Caller)new CallerMock((Object)this.m2service), this.event);
        Mockito.when((Object)this.view.getColumnSortList()).thenReturn(null);
        presenter.init();
        presenter.dataProvider = dataProvider = (ArtifactListPresenterImpl.RefreshableAsyncDataProvider)Mockito.spy((Object)presenter.dataProvider);
        presenter.search("filters");
        ((Event)Mockito.verify(this.event)).fire((Object)((NotificationEvent)ArgumentMatchers.any(NotificationEvent.class)));
        ((ArtifactListPresenterImpl.RefreshableAsyncDataProvider)Mockito.verify((Object)dataProvider)).addDataDisplay((HasData)ArgumentMatchers.any());
        ((ArtifactListPresenterImpl.RefreshableAsyncDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.never())).goToFirstPage();
        ((M2RepoService)Mockito.verify((Object)this.m2service)).listArtifacts((JarListPageRequest)this.request.capture());
        JarListPageRequest searchRequest = (JarListPageRequest)this.request.getValue();
        ArtifactListTest.verifyRequest(searchRequest, null, "filters", 53, 19, true);
        ((HasData)Mockito.verify(this.table)).setRowCount(61, true);
        Mockito.reset((Object[])new Event[]{this.event});
        Mockito.reset((Object[])new ArtifactListPresenterImpl.RefreshableAsyncDataProvider[]{dataProvider});
        presenter.search("other filters");
        ((Event)Mockito.verify(this.event)).fire((Object)((NotificationEvent)ArgumentMatchers.any(NotificationEvent.class)));
        ((ArtifactListPresenterImpl.RefreshableAsyncDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.never())).addDataDisplay((HasData)ArgumentMatchers.any());
        ((ArtifactListPresenterImpl.RefreshableAsyncDataProvider)Mockito.verify((Object)dataProvider)).goToFirstPage();
    }

    @Test
    public void testNoEvent() {
        ArtifactListPresenterImpl.RefreshableAsyncDataProvider dataProvider;
        ArtifactListPresenterImpl presenter = new ArtifactListPresenterImpl(this.view, (Caller)new CallerMock((Object)this.m2service), this.event);
        Mockito.when((Object)this.view.getColumnSortList()).thenReturn(null);
        presenter.init();
        presenter.dataProvider = dataProvider = (ArtifactListPresenterImpl.RefreshableAsyncDataProvider)Mockito.spy((Object)presenter.dataProvider);
        presenter.notifyOnRefresh(false);
        presenter.search("filters");
        presenter.refresh();
        ((Event)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire((Object)((NotificationEvent)ArgumentMatchers.any(NotificationEvent.class)));
    }

    @Test
    public void testDefaultColumns() {
        ArtifactListPresenterImpl presenter = new ArtifactListPresenterImpl(this.view, (Caller)new CallerMock((Object)this.m2service), this.event);
        presenter.init();
        presenter.setup(new ColumnType[]{ColumnType.GAV});
        ((ArtifactListView)Mockito.verify((Object)this.view)).setup(new ColumnType[]{ColumnType.GAV});
        presenter.getView();
        ((ArtifactListView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setup(new ColumnType[0]);
    }

    @Test
    public void testColumnSortList() {
        ArtifactListPresenterImpl presenter = new ArtifactListPresenterImpl(this.view, (Caller)new CallerMock((Object)this.m2service), this.event);
        presenter.init();
        Mockito.when((Object)this.sortInfo.isAscending()).thenReturn((Object)false);
        Mockito.when((Object)this.column.getDataStoreName()).thenReturn((Object)"X");
        presenter.search("");
        ((M2RepoService)Mockito.verify((Object)this.m2service)).listArtifacts((JarListPageRequest)this.request.capture());
        ArtifactListTest.verifyRequest((JarListPageRequest)this.request.getValue(), "X", "", 53, 19, false);
        ((HasData)Mockito.verify(this.table)).setRowCount(61, true);
    }

    @Test
    public void testShowPom() {
        ArtifactListPresenterImpl presenter = new ArtifactListPresenterImpl(this.view, (Caller)new CallerMock((Object)this.m2service), this.event);
        presenter.init();
        presenter.onOpenPom("");
        ((ArtifactListView)Mockito.verify((Object)this.view)).showPom(POM_TEXT);
    }

    private static void verifyRequest(JarListPageRequest request, String dataSourceName, String filters, Integer pageSize, int startRowIndex, boolean isAscending) {
        Assert.assertEquals((Object)dataSourceName, (Object)request.getDataSourceName());
        Assert.assertEquals((Object)filters, (Object)request.getFilters());
        Assert.assertEquals((Object)pageSize, (Object)request.getPageSize());
        Assert.assertEquals((long)startRowIndex, (long)request.getStartRowIndex());
        Assert.assertEquals((Object)isAscending, (Object)request.isAscending());
    }
}

