/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.m2repo.client.editor.MavenRepositoryPagedJarTable;
import org.guvnor.m2repo.client.widgets.ArtifactListPresenter;
import org.guvnor.m2repo.client.widgets.ArtifactListView;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class MavenRepositoryPagedJarTableTest {
    @Mock
    private ArtifactListPresenter presenter;
    @Mock
    private ArtifactListView view;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private User identity;
    private MavenRepositoryPagedJarTable table;

    @Before
    public void setup() {
        Mockito.when((Object)this.presenter.getView()).thenReturn((Object)this.view);
        MavenRepositoryPagedJarTable wrapped = new MavenRepositoryPagedJarTable(this.presenter, this.authorizationManager, this.identity);
        this.table = (MavenRepositoryPagedJarTable)Mockito.spy((Object)wrapped);
    }

    @Test
    public void downloadJARButtonIncludedWhenUserHasPermission() {
        Mockito.when((Object)this.authorizationManager.authorize((String)ArgumentMatchers.eq((Object)"jar.download"), (User)ArgumentMatchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.table.init();
        ((MavenRepositoryPagedJarTable)Mockito.verify((Object)this.table, (VerificationMode)Mockito.times((int)1))).addDownloadJARButton();
    }

    @Test
    public void downloadJARButtonExcludedWhenUserLacksPermission() {
        Mockito.when((Object)this.authorizationManager.authorize((String)ArgumentMatchers.eq((Object)"jar.download"), (User)ArgumentMatchers.eq((Object)this.identity))).thenReturn((Object)false);
        this.table.init();
        ((MavenRepositoryPagedJarTable)Mockito.verify((Object)this.table, (VerificationMode)Mockito.never())).addDownloadJARButton();
    }
}

