/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.guvnor.messageconsole.utils.CSVConverter;
import org.junit.Assert;
import org.junit.Test;

public class CSVConverterTest {
    @Test
    public void testNull() {
        String csv = CSVConverter.convertTable(null);
        Assert.assertTrue((boolean)csv.equals(""));
    }

    @Test
    public void testEmpty() {
        ArrayList table = new ArrayList();
        String csv = CSVConverter.convertTable(table);
        Assert.assertTrue((boolean)csv.equals(""));
    }

    @Test
    public void testSimpleCSV() {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(Arrays.asList("NAME", "AGE", "CITY"));
        table.add(Arrays.asList("John", "32", "Paris"));
        table.add(Arrays.asList("Paul", "41", "New York"));
        table.add(Arrays.asList("Mary", "34", "Santiago"));
        String csv = CSVConverter.convertTable(table);
        Assert.assertTrue((boolean)csv.equals("\"NAME\",\"AGE\",\"CITY\"\n\"John\",\"32\",\"Paris\"\n\"Paul\",\"41\",\"New York\"\n\"Mary\",\"34\",\"Santiago\""));
    }

    @Test
    public void testComplexCSV() {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(Arrays.asList("NAME", "AGE", "CITY"));
        table.add(Arrays.asList("John", "32", "Paris"));
        table.add(Arrays.asList(new String[0]));
        table.add(Arrays.asList("Peter", "", "New York, S\u00e3o Paulo"));
        table.add(Arrays.asList("Mary \"Rose\" O'Brien", "34", "Santiago"));
        table.add(Arrays.asList(""));
        table.add(Arrays.asList("SILVA, A. G., SOUZA, B. R.", "29", "Recife", "Brazil"));
        String csv = CSVConverter.convertTable(table);
        Assert.assertTrue((boolean)csv.equals("\"NAME\",\"AGE\",\"CITY\"\n\"John\",\"32\",\"Paris\"\n\n\"Peter\",\"\",\"New York, S\u00e3o Paulo\"\n\"Mary \"\"Rose\"\" O'Brien\",\"34\",\"Santiago\"\n\"\"\n\"SILVA, A. G., SOUZA, B. R.\",\"29\",\"Recife\",\"Brazil\""));
    }
}

