/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.search.Sort;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.backend.infinispan.ickl.IckleConverter;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanContext;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanSchemaStore;
import org.uberfire.ext.metadata.backend.infinispan.provider.MappingProvider;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.provider.IndexProvider;

public class InfinispanIndexProvider
implements IndexProvider {
    private final InfinispanContext infinispanContext;
    private final InfinispanSchemaStore schemaStore;
    private final IckleConverter ickleConverter;
    private Logger logger = LoggerFactory.getLogger(InfinispanIndexProvider.class);

    public InfinispanIndexProvider(InfinispanContext infinispanContext, MappingProvider mappingProvider) {
        this.infinispanContext = infinispanContext;
        this.schemaStore = new InfinispanSchemaStore(this.infinispanContext, mappingProvider);
        this.ickleConverter = new IckleConverter();
    }

    public boolean isFreshIndex(KCluster cluster) {
        return this.getIndexSize(cluster.getClusterId()) == 0L;
    }

    public void index(KObject kObject) {
        this.schemaStore.updateSchema(kObject);
        this.infinispanContext.getCache(kObject.getClusterId()).put((Object)kObject.getId(), (Object)kObject);
    }

    public void index(List<KObject> elements) {
        elements.forEach(ko -> this.index((KObject)ko));
    }

    public boolean exists(String index, String id) {
        return Optional.ofNullable(this.infinispanContext.getCache(index)).map(i -> i.containsKey((Object)id)).orElse(false);
    }

    public void delete(String index) {
    }

    public void delete(String index, String id) {
        if (this.exists(index, id)) {
            this.infinispanContext.getCache(index).remove((Object)id);
        }
    }

    public List<KObject> findById(String index, String id) throws IOException {
        PortablePreconditions.checkNotEmpty((String)"index", (String)index);
        PortablePreconditions.checkNotEmpty((String)"id", (String)id);
        List<String> types = this.infinispanContext.getTypes(index);
        return types.stream().map(type -> this.getQueryFactory(index).from(type).having("id").eq((Object)id).build().list()).flatMap(x -> x.stream()).map(x -> (KObject)x).collect(Collectors.toList());
    }

    public void rename(String index, String id, KObject to) {
        PortablePreconditions.checkNotEmpty((String)"from", (String)index);
        PortablePreconditions.checkNotEmpty((String)"id", (String)id);
        PortablePreconditions.checkNotNull((String)"to", (Object)to);
        PortablePreconditions.checkNotEmpty((String)"clusterId", (String)to.getClusterId());
        PortablePreconditions.checkCondition((String)"renames are allowed only from same cluster", (boolean)to.getClusterId().equals(index));
        if (this.exists(index, id)) {
            this.delete(index, id);
            this.index(to);
        }
    }

    public long getIndexSize(String index) {
        return this.infinispanContext.getCache(index).size();
    }

    public List<KObject> findByQuery(List<String> indices, org.apache.lucene.search.Query query, int limit) {
        Stream<KObject> stream = this.findByQueryRaw(indices, query, null).stream().map(q -> this.checkQuery(() -> q.list())).flatMap(x -> x.stream()).map(this::toKObject);
        if (limit > 0) {
            stream = stream.limit(limit);
        }
        return stream.collect(Collectors.toList());
    }

    public List<KObject> findByQuery(List<String> indices, org.apache.lucene.search.Query query, Sort sort, int limit) {
        Stream<KObject> stream = this.findByQueryRaw(indices, query, sort).stream().map(q -> this.checkQuery(() -> q.list())).flatMap(x -> x.stream()).map(this::toKObject);
        if (limit > 0) {
            stream = stream.limit(limit);
        }
        return stream.collect(Collectors.toList());
    }

    private List<KObject> checkQuery(Supplier<List<KObject>> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private Integer checkHitsQuery(Supplier<Integer> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long findHitsByQuery(List<String> indices, org.apache.lucene.search.Query query) {
        return this.findByQueryRaw(indices, query, null).stream().mapToInt(q -> this.checkHitsQuery(() -> q.getResultSize())).sum();
    }

    public List<String> getIndices() {
        return this.infinispanContext.getIndices();
    }

    protected QueryFactory getQueryFactory(String index) {
        return Search.getQueryFactory(this.infinispanContext.getCache(index.toLowerCase()));
    }

    public void dispose() {
        this.infinispanContext.dispose();
    }

    private List<Query> findByQueryRaw(List<String> indices, org.apache.lucene.search.Query query, Sort sort) {
        String whereClause = this.ickleConverter.where(query);
        String sortClause = this.ickleConverter.sort(sort);
        List<String> ind = indices;
        if (indices == null || indices.isEmpty()) {
            ind = this.getIndices();
        }
        return ind.stream().map(index -> {
            QueryFactory qf = this.getQueryFactory((String)index);
            return this.infinispanContext.getTypes((String)index).stream().map(type -> this.buildQuery((String)type, whereClause, sortClause)).map(q -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Ickle Query: " + q);
                }
                return qf.create(q);
            }).collect(Collectors.toList());
        }).flatMap(x -> x.stream()).collect(Collectors.toList());
    }

    private KObject toKObject(Object o) {
        return (KObject)o;
    }

    private String buildQuery(String type, String whereClause, String sortClause) {
        StringBuilder sb = new StringBuilder();
        sb.append("from org.kie.").append(type.trim()).append(" ").append(whereClause.trim()).append(" ").append(sortClause.trim());
        return sb.toString();
    }
}

