/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.ickl;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.metadata.backend.infinispan.ickl.IckleConverter;

public class IcklConverterTest {
    private IckleConverter ickleConverter;

    @Before
    public void setUp() {
        this.ickleConverter = new IckleConverter();
    }

    @Test
    public void testTermQueryConversion() {
        TermQuery query = new TermQuery(new Term("a.term", "theResult"));
        String queryString = this.ickleConverter.convert((Query)query);
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo((Object)"a__term:'theResult'");
    }

    @Test
    public void testWildcardQueryConversion() {
        WildcardQuery query = new WildcardQuery(new Term("a.term", "123*"));
        String queryString = this.ickleConverter.convert((Query)query);
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo((Object)"a__term:'123*'");
    }

    @Test
    public void testMatchAllDocsQueryQueryConversion() {
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        String queryString = this.ickleConverter.convert((Query)query);
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo((Object)"");
    }

    @Test
    public void testWhereClause() {
        WildcardQuery query = new WildcardQuery(new Term("a.term", "123*"));
        String queryString = this.ickleConverter.where((Query)query);
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo((Object)"where a__term:'123*'");
        query = new MatchAllDocsQuery();
        queryString = this.ickleConverter.where((Query)query);
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo((Object)"");
    }

    @Test
    public void testSortConvert() {
        Sort sort = new Sort();
        String sortString = this.ickleConverter.convert(sort);
        AssertionsForClassTypes.assertThat((String)sortString).isEqualTo((Object)"");
        sort = new Sort(new SortField("a.sort.field", SortField.Type.STRING));
        sortString = this.ickleConverter.convert(sort);
        AssertionsForClassTypes.assertThat((String)sortString).isEqualTo((Object)"a__sort__field ASC");
        sort = new Sort(new SortField("a.sort.field", SortField.Type.STRING, true));
        sortString = this.ickleConverter.convert(sort);
        AssertionsForClassTypes.assertThat((String)sortString).isEqualTo((Object)"a__sort__field DESC");
        sort = new Sort(new SortField[]{new SortField("a.sort.field", SortField.Type.STRING, true), new SortField("another.sort.field", SortField.Type.STRING)});
        sortString = this.ickleConverter.convert(sort);
        AssertionsForClassTypes.assertThat((String)sortString).isEqualTo((Object)"a__sort__field DESC,another__sort__field ASC");
    }

    @Test
    public void testSort() {
        Sort sort = new Sort();
        String sortString = this.ickleConverter.sort(sort);
        AssertionsForClassTypes.assertThat((String)sortString).isEqualTo((Object)"");
        sort = new Sort(new SortField[]{new SortField("a.sort.field", SortField.Type.STRING, true), new SortField("another.sort.field", SortField.Type.STRING)});
        sortString = this.ickleConverter.sort(sort);
        AssertionsForClassTypes.assertThat((String)sortString).isEqualTo((Object)"order by a__sort__field DESC,another__sort__field ASC");
    }
}

