/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Field;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Message;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Schema;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanContext;
import org.uberfire.ext.metadata.backend.infinispan.provider.MappingProvider;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.model.KObject;

public class InfinispanSchemaStore {
    private InfinispanContext infinispanContext;
    private final MappingProvider mappingProvider;

    public InfinispanSchemaStore(InfinispanContext infinispanContext, MappingProvider mappingProvider) {
        this.infinispanContext = infinispanContext;
        this.mappingProvider = mappingProvider;
    }

    public void updateSchema(KObject kObject) {
        String clustedId = AttributesUtil.toProtobufFormat(kObject.getClusterId());
        Optional<Schema> storedSchema = this.infinispanContext.getSchema(clustedId);
        if (!storedSchema.isPresent()) {
            Schema newSchema = this.mappingProvider.getMapping(kObject);
            newSchema.getMessages().forEach(message -> message.setFields(this.reorderFields(new ArrayList<Field>(message.getFields()))));
            this.infinispanContext.addSchema(newSchema);
            this.infinispanContext.addProtobufSchema(kObject.getClusterId(), newSchema);
        } else {
            Object newMessages;
            String type = AttributesUtil.toProtobufFormat(kObject.getClusterId() + "_" + kObject.getType().getName());
            Optional<Message> storedMessage = this.getMessage(storedSchema.get(), type);
            HashSet<Message> messages = new HashSet<Message>();
            if (storedMessage.isPresent()) {
                newMessages = this.merge(storedMessage.get(), this.getMessage(kObject));
                messages.addAll(storedSchema.get().getMessages());
                messages.remove(storedMessage.get());
                messages.add((Message)newMessages);
            } else {
                newMessages = this.mappingProvider.buildMessages(kObject);
                messages.addAll((Collection<Message>)newMessages);
                messages.addAll(storedSchema.get().getMessages());
            }
            Schema newSchema = this.mappingProvider.buildSchema(kObject, messages);
            this.infinispanContext.addSchema(newSchema);
            this.infinispanContext.addProtobufSchema(kObject.getClusterId(), newSchema);
        }
    }

    private Message getMessage(KObject kObject) {
        return this.mappingProvider.buildMessages(kObject).iterator().next();
    }

    protected Message merge(Message storedMessage, Message newMessage) {
        ArrayList<Field> fields = new ArrayList<Field>(storedMessage.getFields());
        newMessage.getFields().forEach(field -> {
            if (!this.containsField((List<Field>)fields, (Field)field) && !this.containsField((List<Field>)new ArrayList<Field>(storedMessage.getFields()), (Field)field)) {
                fields.add((Field)field);
            }
        });
        Set<Field> reorderedFields = this.reorderFields(fields);
        return new Message(storedMessage.getName(), reorderedFields);
    }

    public boolean containsField(List<Field> fields, Field field) {
        return fields.stream().anyMatch(f -> field.getName().equals(f.getName()));
    }

    private Set<Field> reorderFields(List<Field> fields) {
        int maxIndex = this.getMaxIndexNumber(fields);
        List unsavedFields = fields.stream().filter(field -> field.getIndex() == 0).collect(Collectors.toList());
        for (Field field2 : unsavedFields) {
            field2.setIndex(++maxIndex);
        }
        return new HashSet<Field>(fields);
    }

    protected int getMaxIndexNumber(List<Field> fields) {
        return fields.stream().sorted(Comparator.comparingInt(Field::getIndex).reversed()).mapToInt(Field::getIndex).findFirst().orElse(0);
    }

    private Optional<Message> getMessage(Schema schema, String type) {
        return schema.getMessages().stream().filter(message -> message.getName().equals(type)).findAny();
    }
}

