/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.ickl.converters;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Test;
import org.uberfire.ext.metadata.backend.infinispan.ickl.IckleConverter;
import org.uberfire.ext.metadata.backend.infinispan.ickl.converters.BooleanQueryConverter;

public class BooleanQueryConverterTest {
    @Test
    public void testSingleBooleanTermQuery() {
        TermQuery query = new TermQuery(new Term("a.term", "theResult"));
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.MUST).build();
        BooleanQueryConverter converter = new BooleanQueryConverter(booleanQuery, new IckleConverter());
        String queryString = converter.convert();
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo("a__term:'theResult'");
    }

    @Test
    public void testSingleClauseBooleanTermQuery() {
        TermQuery query = new TermQuery(new Term("a.term", "theResult"));
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.MUST).build();
        BooleanQueryConverter converter = new BooleanQueryConverter(booleanQuery, new IckleConverter());
        String queryString = converter.convert();
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo("a__term:'theResult'");
    }

    @Test
    public void testNotBooleanQuery() {
        TermQuery query = new TermQuery(new Term("a.term", "theResult"));
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.MUST_NOT).build();
        BooleanQueryConverter converter = new BooleanQueryConverter(booleanQuery, new IckleConverter());
        String queryString = converter.convert();
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo("NOT a__term:'theResult'");
    }

    @Test
    public void testMultipleBooleanTermQuery() {
        TermQuery query = new TermQuery(new Term("a.term", "theResult"));
        TermQuery query2 = new TermQuery(new Term("a.term.other", "123"));
        BooleanQuery orBooleanQuery = new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.SHOULD).add((Query)query2, BooleanClause.Occur.MUST_NOT).build();
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.MUST).add((Query)query2, BooleanClause.Occur.MUST).add((Query)orBooleanQuery, BooleanClause.Occur.MUST).build();
        BooleanQueryConverter converter = new BooleanQueryConverter(booleanQuery, new IckleConverter());
        String queryString = converter.convert();
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo("a__term:'theResult' AND a__term__other:123 AND (a__term:'theResult' OR NOT a__term__other:123)");
    }
}

