/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.ickl.converters;

import java.util.Arrays;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.uberfire.ext.metadata.backend.infinispan.ickl.FieldConverter;
import org.uberfire.ext.metadata.backend.infinispan.ickl.FieldConverterImpl;
import org.uberfire.ext.metadata.backend.infinispan.ickl.converters.TermQueryConverter;

@RunWith(value=Parameterized.class)
public class TermQueryConverterTest {
    @Parameterized.Parameter
    public String termText;
    @Parameterized.Parameter(value=1)
    public String expectedConversionResult;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({"aString", "a__term:'aString'"}, {"123", "a__term:123"}, {"0.3", "a__term:0.3"}, {"true", "a__term:true"});
    }

    @Test
    public void test() {
        TermQuery query = new TermQuery(new Term("a.term", this.termText));
        TermQueryConverter converter = new TermQueryConverter(query, (FieldConverter)new FieldConverterImpl());
        String queryString = converter.convert();
        AssertionsForClassTypes.assertThat((String)queryString).isEqualTo(this.expectedConversionResult);
    }
}

