/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.metadata.backend.infinispan.provider.KieProtostreamMarshaller;

public class KieProtostreamMarshallerTest {
    @Test
    public void testMultipleMarshallers() throws IOException, InterruptedException, ClassNotFoundException {
        KieProtostreamMarshaller marshaller = new KieProtostreamMarshaller();
        DynamicEntity1 entity1a = new DynamicEntity1(42, "value1");
        DynamicEntity1 entity1b = new DynamicEntity1(23, "other value");
        DynamicEntity1 entity1c = new DynamicEntity1(23, "yet value");
        DynamicEntity2 entity2 = new DynamicEntity2("org_infinispan_test", 1);
        marshaller.registerSchema("entity1a.proto", entity1a.getProto(), DynamicEntity1.class);
        marshaller.registerSchema("entity1b.proto", entity1b.getProto(), DynamicEntity1.class);
        marshaller.registerSchema("entity2.proto", entity2.getProto(), DynamicEntity2.class);
        marshaller.registerMarshaller((KieProtostreamMarshaller.KieMarshallerSupplier)new KieProtostreamMarshaller.KieMarshallerSupplier<DynamicEntity1>(){

            public String extractTypeFromEntity(DynamicEntity1 entity) {
                return entity.getFullyQualifiedType();
            }

            public Class<DynamicEntity1> getJavaClass() {
                return DynamicEntity1.class;
            }

            public BaseMarshaller<DynamicEntity1> getMarshallerForType(String typeName) {
                return new DynamicEntity1Marshaller(typeName);
            }
        });
        marshaller.registerMarshaller((KieProtostreamMarshaller.KieMarshallerSupplier)new KieProtostreamMarshaller.KieMarshallerSupplier<DynamicEntity2>(){

            public String extractTypeFromEntity(DynamicEntity2 entity) {
                return entity.getType();
            }

            public Class<DynamicEntity2> getJavaClass() {
                return DynamicEntity2.class;
            }

            public BaseMarshaller<DynamicEntity2> getMarshallerForType(String typeName) {
                return new DynamicEntity2Marshaller(typeName);
            }
        });
        SerializationContext serCtx = marshaller.getSerializationContext();
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"uuid.proto", (String)"message unique_id { required string uuid=1; }"));
        serCtx.registerMarshaller((BaseMarshaller)new UUIDMarshaller());
        byte[] bytes1a = marshaller.objectToByteBuffer((Object)entity1a);
        byte[] bytes1b = marshaller.objectToByteBuffer((Object)entity1b);
        byte[] bytes1c = marshaller.objectToByteBuffer((Object)entity1c);
        byte[] bytes2 = marshaller.objectToByteBuffer((Object)entity2);
        byte[] stringBytes = marshaller.objectToByteBuffer((Object)"Sample String");
        UUID uuid = UUID.randomUUID();
        byte[] uuidBytes = marshaller.objectToByteBuffer((Object)uuid);
        DynamicEntity1 fromBytes1a = (DynamicEntity1)marshaller.objectFromByteBuffer(bytes1a);
        DynamicEntity1 fromBytes1b = (DynamicEntity1)marshaller.objectFromByteBuffer(bytes1b);
        DynamicEntity1 fromBytes1c = (DynamicEntity1)marshaller.objectFromByteBuffer(bytes1c);
        DynamicEntity2 fromBytes2 = (DynamicEntity2)marshaller.objectFromByteBuffer(bytes2);
        String stringFromBytes = (String)marshaller.objectFromByteBuffer(stringBytes);
        UUID uuidFromBytes = (UUID)marshaller.objectFromByteBuffer(uuidBytes);
        Assert.assertEquals((Object)entity1a, (Object)fromBytes1a);
        Assert.assertEquals((Object)entity1b, (Object)fromBytes1b);
        Assert.assertEquals((Object)entity1c, (Object)fromBytes1c);
        Assert.assertEquals((Object)entity2, (Object)fromBytes2);
        Assert.assertEquals((Object)stringFromBytes, (Object)"Sample String");
        Assert.assertEquals((Object)uuidFromBytes, (Object)uuid);
        ArrayList mixedEntities = new ArrayList(30);
        IntStream.range(0, 50).boxed().forEach(i -> mixedEntities.add(new DynamicEntity1(42, "value" + i)));
        IntStream.range(0, 70).boxed().forEach(i -> mixedEntities.add(new DynamicEntity1(23, "value" + i)));
        IntStream.range(0, 80).boxed().forEach(i -> mixedEntities.add(new DynamicEntity2("org_infinispan_test", (Integer)i)));
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        AtomicInteger failures = new AtomicInteger(0);
        for (int i2 = 0; i2 < 10; ++i2) {
            Set tasks = mixedEntities.stream().map(o -> () -> {
                try {
                    byte[] toBytes = marshaller.objectToByteBuffer(o);
                    Object back = marshaller.objectFromByteBuffer(toBytes);
                    if (!o.equals(back)) {
                        failures.incrementAndGet();
                    }
                    return null;
                }
                catch (IOException | ClassNotFoundException | InterruptedException e) {
                    failures.incrementAndGet();
                    return null;
                }
            }).collect(Collectors.toSet());
            executorService.invokeAll(tasks);
            Assert.assertEquals((long)0L, (long)failures.get());
        }
    }

    @Test
    public void testSingleProviderForClassHierarchy() throws Exception {
        KieProtostreamMarshaller marshaller = new KieProtostreamMarshaller();
        EntityImpl entity1a = new EntityImpl(10, "FieldValue-1a");
        EntityImpl entity1b = new EntityImpl(20, "FieldValue-1b");
        EntityInterface entity2a = this.createEntityFromAnonymousClass(2, "FieldValue-2a");
        EntityInterface entity2b = this.createEntityFromAnonymousClass(2, "FieldValue-2b");
        marshaller.registerSchema("entity1a.proto", entity1a.getProto(), EntityInterface.class);
        marshaller.registerSchema("entity1b.proto", entity1b.getProto(), EntityInterface.class);
        marshaller.registerSchema("entity2.proto", entity2a.getProto(), EntityInterface.class);
        marshaller.registerMarshaller((KieProtostreamMarshaller.KieMarshallerSupplier)new KieProtostreamMarshaller.KieMarshallerSupplier<EntityInterface>(){

            public String extractTypeFromEntity(EntityInterface entity) {
                return entity.getType();
            }

            public Class<EntityInterface> getJavaClass() {
                return EntityInterface.class;
            }

            public BaseMarshaller<EntityInterface> getMarshallerForType(String typeName) {
                return new EntityMarshaller(typeName);
            }
        });
        byte[] bytes1a = marshaller.objectToByteBuffer((Object)entity1a);
        byte[] bytes1b = marshaller.objectToByteBuffer((Object)entity1b);
        byte[] bytes2a = marshaller.objectToByteBuffer((Object)entity2a);
        byte[] bytes2b = marshaller.objectToByteBuffer((Object)entity2b);
        EntityInterface fromBytes1a = (EntityInterface)marshaller.objectFromByteBuffer(bytes1a);
        EntityInterface fromBytes1b = (EntityInterface)marshaller.objectFromByteBuffer(bytes1b);
        EntityInterface fromBytes2a = (EntityInterface)marshaller.objectFromByteBuffer(bytes2a);
        EntityInterface fromBytes2b = (EntityInterface)marshaller.objectFromByteBuffer(bytes2b);
        Assert.assertEquals((Object)entity1a.getId(), (Object)fromBytes1a.getId());
        Assert.assertEquals((Object)entity1a.getFieldValue(), (Object)fromBytes1a.getFieldValue());
        Assert.assertEquals((Object)entity1b.getId(), (Object)fromBytes1b.getId());
        Assert.assertEquals((Object)entity1b.getFieldValue(), (Object)fromBytes1b.getFieldValue());
        Assert.assertEquals((Object)entity2a.getId(), (Object)fromBytes2a.getId());
        Assert.assertEquals((Object)entity2a.getFieldValue(), (Object)fromBytes2a.getFieldValue());
        Assert.assertEquals((Object)entity2b.getId(), (Object)fromBytes2b.getId());
        Assert.assertEquals((Object)entity2b.getFieldValue(), (Object)fromBytes2b.getFieldValue());
    }

    private EntityInterface createEntityFromAnonymousClass(final Integer id, final String fieldValue) {
        return new EntityInterface(){

            @Override
            public String getFieldValue() {
                return fieldValue;
            }

            @Override
            public Integer getId() {
                return id;
            }
        };
    }

    class DynamicEntity2Marshaller
    implements MessageMarshaller<DynamicEntity2> {
        private final String type;

        DynamicEntity2Marshaller(String type) {
            this.type = type;
        }

        public DynamicEntity2 readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            String type = reader.readString("theType");
            Integer rank = reader.readInt("rank");
            return new DynamicEntity2(type, rank);
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, DynamicEntity2 obj) throws IOException {
            writer.writeString("theType", obj.theType);
            writer.writeInt("rank", obj.rank);
        }

        public Class<? extends DynamicEntity2> getJavaClass() {
            return DynamicEntity2.class;
        }

        public String getTypeName() {
            return this.type;
        }
    }

    class DynamicEntity1Marshaller
    implements MessageMarshaller<DynamicEntity1> {
        private final String type;

        DynamicEntity1Marshaller(String type) {
            this.type = type;
        }

        public DynamicEntity1 readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            Integer seed = reader.readInt("seed");
            String value = reader.readString("value");
            return new DynamicEntity1(seed, value);
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, DynamicEntity1 obj) throws IOException {
            writer.writeInt("seed", obj.seed);
            writer.writeString("value", obj.value);
        }

        public Class<? extends DynamicEntity1> getJavaClass() {
            return DynamicEntity1.class;
        }

        public String getTypeName() {
            return this.type;
        }
    }

    class DynamicEntity2 {
        private String theType;
        private Integer rank;

        DynamicEntity2(String theType, Integer rank) {
            this.theType = theType;
            this.rank = rank;
        }

        String getType() {
            return this.theType;
        }

        String getProto() {
            return String.format("message %s { required string theType=1; required int32 rank=2; }", this.getType());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicEntity2 that = (DynamicEntity2)o;
            return Objects.equals(this.theType, that.theType) && Objects.equals(this.rank, that.rank);
        }

        public int hashCode() {
            return Objects.hash(this.theType, this.rank);
        }

        public String toString() {
            return "DynamicEntity2{theType='" + this.theType + '\'' + ", rank=" + this.rank + '}';
        }
    }

    class DynamicEntity1 {
        private int seed;
        private String value;

        DynamicEntity1(int seed, String value) {
            this.seed = seed;
            this.value = value;
        }

        String getFullyQualifiedType() {
            return "type_" + this.seed;
        }

        String getProto() {
            return String.format("message %s { required int32 seed=1; required string value=2; }", this.getFullyQualifiedType());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicEntity1 that = (DynamicEntity1)o;
            return this.seed == that.seed && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.seed, this.value);
        }

        public String toString() {
            return "DynamicEntity1{seed=" + this.seed + ", value='" + this.value + '\'' + '}';
        }
    }

    class UUIDMarshaller
    implements MessageMarshaller<UUID> {
        UUIDMarshaller() {
        }

        public UUID readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            return UUID.fromString(reader.readString("uuid"));
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, UUID uuid) throws IOException {
            writer.writeString("uuid", uuid.toString());
        }

        public Class<? extends UUID> getJavaClass() {
            return UUID.class;
        }

        public String getTypeName() {
            return "unique_id";
        }
    }

    class EntityMarshaller
    implements MessageMarshaller<EntityInterface> {
        private final String type;

        EntityMarshaller(String type) {
            this.type = type;
        }

        public EntityInterface readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            Integer id = reader.readInt("id");
            String fieldValue = reader.readString("fieldValue");
            return new EntityImpl(id, fieldValue);
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, EntityInterface obj) throws IOException {
            writer.writeInt("id", obj.getId());
            writer.writeString("fieldValue", obj.getFieldValue());
        }

        public Class<? extends EntityInterface> getJavaClass() {
            return EntityInterface.class;
        }

        public String getTypeName() {
            return this.type;
        }
    }

    class EntityImpl
    implements EntityInterface {
        private final Integer id;
        private final String fieldValue;

        EntityImpl(Integer id, String fieldValue) {
            this.id = id;
            this.fieldValue = fieldValue;
        }

        @Override
        public String getFieldValue() {
            return this.fieldValue;
        }

        @Override
        public Integer getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityImpl entity = (EntityImpl)o;
            return Objects.equals(this.id, entity.id) && Objects.equals(this.fieldValue, entity.fieldValue);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.fieldValue);
        }

        public String toString() {
            return "EntityImpl{id=" + this.id + ", fieldValue='" + this.fieldValue + '\'' + '}';
        }
    }

    static interface EntityInterface {
        default public String getType() {
            return "Type" + this.getId();
        }

        public String getFieldValue();

        public Integer getId();

        default public String getProto() {
            return String.format("message %s { required int32 id=1; required string fieldValue=2; }", this.getType());
        }
    }
}

