/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanPingService;

@RunWith(value=MockitoJUnitRunner.class)
public class InfinispanPingServiceTest {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RemoteCacheImpl remoteCache;

    @Before
    public void setUp() {
        Mockito.when((Object)this.remoteCache.ping().isSuccess()).thenReturn((Object)true);
    }

    @Test
    public void testPingSuccess() {
        InfinispanPingService service = (InfinispanPingService)Mockito.spy((Object)new InfinispanPingService(this.remoteCache));
        Assert.assertTrue((boolean)service.ping());
        service.stop();
        Mockito.when((Object)this.remoteCache.ping().isSuccess()).thenReturn((Object)false);
        service = (InfinispanPingService)Mockito.spy((Object)new InfinispanPingService(this.remoteCache));
        Assert.assertFalse((boolean)service.ping());
        service.stop();
    }

    @Test
    public void testPingFailure() {
        Mockito.when((Object)this.remoteCache.ping().isSuccess()).thenThrow(new Throwable[]{new RuntimeException("error")});
        InfinispanPingService service = (InfinispanPingService)Mockito.spy((Object)new InfinispanPingService(this.remoteCache));
        Assert.assertFalse((boolean)service.ping());
        service.stop();
    }

    @Test
    public void testExternalTimeoutVariable() {
        InfinispanPingService service = (InfinispanPingService)Mockito.spy((Object)new InfinispanPingService(this.remoteCache));
        int result = service.getTimeoutOrElse("org.appformer.ext.metadata.infinispan.ping", 5);
        Assert.assertEquals((long)5L, (long)result);
        System.setProperty("org.appformer.ext.metadata.infinispan.ping", String.valueOf(4));
        service = (InfinispanPingService)Mockito.spy((Object)new InfinispanPingService(this.remoteCache));
        result = service.getTimeoutOrElse("org.appformer.ext.metadata.infinispan.ping", 5);
        Assert.assertEquals((long)4L, (long)result);
        System.setProperty("org.appformer.ext.metadata.infinispan.ping", "");
        service = (InfinispanPingService)Mockito.spy((Object)new InfinispanPingService(this.remoteCache));
        result = service.getTimeoutOrElse("org.appformer.ext.metadata.infinispan.ping", 5);
        Assert.assertEquals((long)5L, (long)result);
    }
}

