/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.proto.schema;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Field;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Message;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.ProtobufScope;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Schema;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.SchemaGenerator;

public class SchemaGeneratorTest {
    private Logger logger = LoggerFactory.getLogger(SchemaGeneratorTest.class);
    private SchemaGenerator schemaGenerator;

    @Before
    public void setUp() {
        this.schemaGenerator = new SchemaGenerator();
    }

    @Test
    public void testBuildField() {
        String generatedField = this.schemaGenerator.buildField(new Field(ProtobufScope.REQUIRED, "int32", "aField", 1));
        String expected = "/* @Field(index=Index.YES, analyze = Analyze.NO, store = Store.YES) */required int32 aField = 1;";
        Assertions.assertThat((String)generatedField).isEqualToIgnoringWhitespace((CharSequence)expected);
        generatedField = this.schemaGenerator.buildField(new Field(ProtobufScope.OPTIONAL, "int32", "aField", 1));
        expected = "/* @Field(index=Index.YES, analyze = Analyze.NO, store = Store.YES) */optional int32 aField = 1;";
        Assertions.assertThat((String)generatedField).isEqualToIgnoringWhitespace((CharSequence)expected);
        generatedField = this.schemaGenerator.buildField(new Field(ProtobufScope.REPEATED, "int32", "aField", 1));
        expected = "/* @Field(index=Index.YES, analyze = Analyze.NO, store = Store.YES) */repeated int32 aField = 1;";
        Assertions.assertThat((String)generatedField).isEqualToIgnoringWhitespace((CharSequence)expected);
    }

    @Test
    public void testBuildMessageWithSingleField() {
        Message message = new Message("KObject", Collections.singleton(new Field(ProtobufScope.REQUIRED, "int32", "aField", 1)));
        String generatedMessage = this.schemaGenerator.buildMessage(message);
        this.logger.debug(generatedMessage);
        Assertions.assertThat((String)this.sanitize(generatedMessage)).isEqualToIgnoringWhitespace((CharSequence)this.read("proto/single-field-message.proto"));
    }

    @Test
    public void testBuildMessageWithMultipleFields() {
        Message message = new Message("KObject", new HashSet<Field>(Arrays.asList(new Field(ProtobufScope.REQUIRED, "int32", "aField", 1), new Field(ProtobufScope.REQUIRED, "string", "anotherField", 2))));
        String generatedMessage = this.schemaGenerator.buildMessage(message);
        Assertions.assertThat((String)this.sanitize(generatedMessage)).isEqualToIgnoringWhitespace((CharSequence)this.read("proto/multi-field-message.proto"));
    }

    @Test
    public void testBuildSchema() {
        Message message = new Message("KObject", new HashSet<Field>(Arrays.asList(new Field(ProtobufScope.REQUIRED, "int32", "embedded", 1), new Field(ProtobufScope.REQUIRED, "string", "anotherEmbedded", 2))));
        Schema schema = new Schema("KObjectSchema", "org.appformer", Collections.singleton(message));
        String generatedMessage = this.schemaGenerator.generate(schema);
        this.logger.debug(generatedMessage);
        Assertions.assertThat((String)this.sanitize(generatedMessage)).isEqualToIgnoringWhitespace((CharSequence)this.read("proto/schema.proto"));
    }

    private String read(String file) {
        URL url = Resources.getResource((String)file);
        try {
            return this.sanitize(Resources.toString((URL)url, (Charset)Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String sanitize(String value) {
        return value.replaceAll("\t", "").replace("\n", "");
    }
}

