/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.metadata.backend.lucene;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.metadata.backend.lucene.FieldFactory;
import org.uberfire.metadata.backend.lucene.LuceneIndexEngine;
import org.uberfire.metadata.backend.lucene.LuceneSetup;
import org.uberfire.metadata.backend.lucene.fields.SimpleFieldFactory;
import org.uberfire.metadata.backend.lucene.setups.BaseLuceneSetup;
import org.uberfire.metadata.engine.MetaModelStore;
import org.uberfire.metadata.model.KObject;
import org.uberfire.metadata.model.KObjectKey;
import org.uberfire.metadata.model.KProperty;
import org.uberfire.metadata.model.schema.MetaType;

public abstract class BaseIndexEngineSimpleTest {
    @Test
    public void testSimpleIndex() throws IOException {
        SimpleFieldFactory factory = new SimpleFieldFactory();
        LuceneIndexEngine engine = new LuceneIndexEngine(this.getMetaModelStore(), (LuceneSetup)this.getLuceneSetup(), (FieldFactory)factory);
        engine.index(new KObject(){

            public String getId() {
                return "unique.id.here";
            }

            public MetaType getType() {
                return new MetaType(){

                    public String getName() {
                        return "Path";
                    }
                };
            }

            public String getClusterId() {
                return "cluster.id.here";
            }

            public String getSegmentId() {
                return "/";
            }

            public String getKey() {
                return "some.key.here";
            }

            public Iterable<KProperty<?>> getProperties() {
                return new HashSet<KProperty<?>>(){
                    {
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "dcore.author";
                            }

                            public String getValue() {
                                return "Some Author name here.";
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<String>(){

                            public String getName() {
                                return "dcore.comment";
                            }

                            public String getValue() {
                                return "My comment file.txt here that has some content that is important to my users.";
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<Integer>(){

                            public String getName() {
                                return "dcore.review";
                            }

                            public Integer getValue() {
                                return 10;
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                        this.add(new KProperty<Date>(){

                            public String getName() {
                                return "dcore.lastModifiedTime";
                            }

                            public Date getValue() {
                                return new Date();
                            }

                            public boolean isSearchable() {
                                return true;
                            }
                        });
                    }
                };
            }
        });
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.author"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.comment"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.review"));
        Assert.assertNotNull((Object)this.getMetaModelStore().getMetaObject("Path").getProperty("dcore.lastModifiedTime"));
        IndexSearcher searcher = this.getLuceneSetup().nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("dcore.author", "some")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("dcore.comment", "users")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        NumericRangeQuery rangeQuery = NumericRangeQuery.newIntRange((String)"dcore.review", (Integer)1, (Integer)15, (boolean)true, (boolean)true);
        searcher.search((Query)rangeQuery, (Collector)collector);
        ScoreDoc[] hits2 = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits2.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        rangeQuery = NumericRangeQuery.newLongRange((String)"dcore.lastModifiedTime", (Long)0L, (Long)new Date().getTime(), (boolean)true, (boolean)true);
        searcher.search((Query)rangeQuery, (Collector)collector);
        hits2 = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits2.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("id", "unique.id.here")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("type", "Path")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        this.getLuceneSetup().nrtRelease(searcher);
        engine.rename(new KObjectKey(){

            public String getId() {
                return "unique.id.here";
            }

            public MetaType getType() {
                return new MetaType(){

                    public String getName() {
                        return "Path";
                    }
                };
            }

            public String getClusterId() {
                return "cluster.id.here";
            }

            public String getSegmentId() {
                return "/";
            }

            public String getKey() {
                return "some.key.here";
            }
        }, new KObjectKey(){

            public String getId() {
                return "other.id.here";
            }

            public MetaType getType() {
                return new MetaType(){

                    public String getName() {
                        return "Path";
                    }
                };
            }

            public String getClusterId() {
                return "other.cluster.id.here";
            }

            public String getSegmentId() {
                return "/";
            }

            public String getKey() {
                return "some.key.here";
            }
        });
        IndexSearcher updatedSearcher = this.getLuceneSetup().nrtSearcher();
        TopScoreDocCollector collector2 = TopScoreDocCollector.create((int)10, (boolean)true);
        updatedSearcher.search((Query)new MatchAllDocsQuery(), (Collector)collector2);
        hits2 = collector2.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits2.length);
        collector2 = TopScoreDocCollector.create((int)10, (boolean)true);
        updatedSearcher.search((Query)new TermQuery(new Term("id", "other.id.here")), (Collector)collector2);
        hits2 = collector2.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits2.length);
        collector2 = TopScoreDocCollector.create((int)10, (boolean)true);
        updatedSearcher.search((Query)new TermQuery(new Term("id", "unique.id.here")), (Collector)collector2);
        hits2 = collector2.topDocs().scoreDocs;
        Assert.assertEquals((long)0L, (long)hits2.length);
        engine.delete(new KObjectKey(){

            public String getId() {
                return "other.id.here";
            }

            public MetaType getType() {
                return new MetaType(){

                    public String getName() {
                        return "Path";
                    }
                };
            }

            public String getClusterId() {
                return "other.cluster.id.here";
            }

            public String getSegmentId() {
                return "/";
            }

            public String getKey() {
                return "some.key.here";
            }
        });
        collector2 = TopScoreDocCollector.create((int)10, (boolean)true);
        updatedSearcher.search((Query)new TermQuery(new Term("id", "other.id.here")), (Collector)collector2);
        hits2 = collector2.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits2.length);
        this.getLuceneSetup().nrtRelease(updatedSearcher);
        IndexSearcher deletedSearcher = this.getLuceneSetup().nrtSearcher();
        TopScoreDocCollector collector3 = TopScoreDocCollector.create((int)10, (boolean)true);
        deletedSearcher.search((Query)new TermQuery(new Term("id", "other.id.here")), (Collector)collector3);
        ScoreDoc[] hits3 = collector3.topDocs().scoreDocs;
        Assert.assertEquals((long)0L, (long)hits3.length);
        this.getLuceneSetup().nrtRelease(deletedSearcher);
    }

    protected abstract BaseLuceneSetup getLuceneSetup();

    protected abstract MetaModelStore getMetaModelStore();
}

