/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.metadata.backend.lucene;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.metadata.backend.lucene.FieldFactory;
import org.uberfire.metadata.backend.lucene.LuceneIndexEngine;
import org.uberfire.metadata.backend.lucene.LuceneSearchIndex;
import org.uberfire.metadata.backend.lucene.LuceneSetup;
import org.uberfire.metadata.backend.lucene.fields.SimpleFieldFactory;
import org.uberfire.metadata.backend.lucene.metamodels.InMemoryMetaModelStore;
import org.uberfire.metadata.backend.lucene.setups.RAMLuceneSetup;
import org.uberfire.metadata.engine.MetaModelStore;
import org.uberfire.metadata.model.KObject;
import org.uberfire.metadata.model.KProperty;
import org.uberfire.metadata.model.schema.MetaType;
import org.uberfire.metadata.search.ClusterSegment;

public class LuceneIndexSearchTest {
    @Test
    public void testSearch() {
        SimpleFieldFactory factory = new SimpleFieldFactory();
        InMemoryMetaModelStore store = new InMemoryMetaModelStore();
        RAMLuceneSetup setup = new RAMLuceneSetup();
        LuceneIndexEngine engine = new LuceneIndexEngine((MetaModelStore)store, (LuceneSetup)setup, (FieldFactory)factory);
        int i = 0;
        while (i < 50) {
            final int index = i++;
            engine.index(new KObject(){

                public String getId() {
                    return "unique.id.here." + index;
                }

                public MetaType getType() {
                    return new MetaType(){

                        public String getName() {
                            return "Path";
                        }
                    };
                }

                public String getClusterId() {
                    return "cluster.id.here." + index % 2;
                }

                public String getSegmentId() {
                    return "/";
                }

                public String getKey() {
                    return "some.key.here." + index;
                }

                public Iterable<KProperty<?>> getProperties() {
                    return new HashSet<KProperty<?>>(){
                        {
                            this.add(new KProperty<String>(){

                                public String getName() {
                                    return "dcore.author";
                                }

                                public String getValue() {
                                    return "Some  Author name Here" + index;
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                            this.add(new KProperty<String>(){

                                public String getName() {
                                    return "filename";
                                }

                                public String getValue() {
                                    if (index % 2 == 0) {
                                        return "File" + index + ".dtxt";
                                    }
                                    return "file" + index + ".txt";
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                            this.add(new KProperty<String>(){

                                public String getName() {
                                    return "dcore.comment";
                                }

                                public String getValue() {
                                    return "My comment here that has some content that is important to my users." + index;
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                            this.add(new KProperty<Integer>(){

                                public String getName() {
                                    return "dcore.review";
                                }

                                public Integer getValue() {
                                    return 10 + index;
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                            this.add(new KProperty<Date>(){

                                public String getName() {
                                    return "dcore.lastModifiedTime";
                                }

                                public Date getValue() {
                                    return new Date();
                                }

                                public boolean isSearchable() {
                                    return true;
                                }
                            });
                        }
                    };
                }
            });
        }
        LuceneSearchIndex searchEngine = new LuceneSearchIndex((LuceneSetup)setup);
        Assert.assertEquals((long)1L, (long)searchEngine.fullTextSearchHits("Here49", new ClusterSegment[0]));
        Assert.assertEquals((long)50L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[0]));
        Assert.assertEquals((long)0L, (long)searchEngine.fullTextSearchHits("file.txt", new ClusterSegment[0]));
        Assert.assertEquals((long)1L, (long)searchEngine.fullTextSearchHits("file10", new ClusterSegment[0]));
        Assert.assertEquals((long)26L, (long)searchEngine.fullTextSearchHits("file10.txt", new ClusterSegment[0]));
        Assert.assertEquals((long)25L, (long)searchEngine.searchByAttrsHits((Map)new HashMap<String, Object>(){
            {
                this.put("filename", "*.txt");
            }
        }, new ClusterSegment[0]));
        Assert.assertEquals((long)25L, (long)searchEngine.searchByAttrsHits((Map)new HashMap<String, Object>(){
            {
                this.put("filename", "*.dtxt");
            }
        }, new ClusterSegment[0]));
        Assert.assertEquals((long)1L, (long)searchEngine.searchByAttrsHits((Map)new HashMap<String, Object>(){
            {
                this.put("filename", "file1.*txt");
            }
        }, new ClusterSegment[0]));
        Assert.assertEquals((long)1L, (long)searchEngine.searchByAttrsHits((Map)new HashMap<String, Object>(){
            {
                this.put("filename", "File0.dtxt");
            }
        }, new ClusterSegment[0]));
        Assert.assertEquals((long)0L, (long)searchEngine.fullTextSearchHits("here49", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.0";
            }

            public String[] segmentIds() {
                return new String[]{"/"};
            }
        }}));
        Assert.assertEquals((long)1L, (long)searchEngine.fullTextSearchHits("here49", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.1";
            }

            public String[] segmentIds() {
                return new String[]{"/"};
            }
        }}));
        Assert.assertEquals((long)25L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.1";
            }

            public String[] segmentIds() {
                return new String[]{"/"};
            }
        }}));
        Assert.assertEquals((long)25L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.1";
            }

            public String[] segmentIds() {
                return new String[0];
            }
        }}));
        Assert.assertEquals((long)25L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.0";
            }

            public String[] segmentIds() {
                return new String[]{"/"};
            }
        }}));
        Assert.assertEquals((long)25L, (long)searchEngine.fullTextSearchHits("comment", new ClusterSegment[]{new ClusterSegment(){

            public String getClusterId() {
                return "cluster.id.here.0";
            }

            public String[] segmentIds() {
                return new String[0];
            }
        }}));
    }
}

