/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.metadata.backend.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.uberfire.metadata.backend.lucene.index.LuceneIndex;

public abstract class BaseLuceneIndex
implements LuceneIndex {
    @Override
    public void indexDocument(String id, Document doc) {
        try {
            this.deleteIfExists(id);
            this.writer().addDocument((Iterable)doc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteIfExists(String ... docIds) {
        boolean deletedSomething = false;
        IndexSearcher searcher = this.nrtSearcher();
        try {
            int[] answers;
            for (int docId : answers = this.lookupDocIdByPK(searcher, docIds)) {
                boolean result;
                if (docId == -1 || !(result = this.writer().tryDeleteDocument(searcher.getIndexReader(), docId))) continue;
                deletedSomething = true;
            }
        }
        catch (Exception ex) {
        }
        finally {
            this.nrtRelease(searcher);
        }
        return deletedSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String sourceId, Document doc) {
        IndexSearcher searcher = this.nrtSearcher();
        try {
            int docId = this.lookupDocIdByPK(searcher, sourceId)[0];
            if (docId != -1) {
                this.writer().tryDeleteDocument(searcher.getIndexReader(), docId);
            }
            this.indexDocument(sourceId, doc);
        }
        catch (IOException ex) {
        }
        finally {
            this.nrtRelease(searcher);
        }
    }

    protected int[] lookupDocIdByPK(IndexSearcher searcher, String ... ids) throws IOException {
        List subReaders = searcher.getIndexReader().leaves();
        TermsEnum[] termsEnums = new TermsEnum[subReaders.size()];
        DocsEnum[] docsEnums = new DocsEnum[subReaders.size()];
        for (int subIDX = 0; subIDX < subReaders.size(); ++subIDX) {
            termsEnums[subIDX] = ((AtomicReaderContext)subReaders.get(subIDX)).reader().fields().terms("id").iterator(null);
        }
        int[] results = new int[ids.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = -1;
        }
        block2: for (int idx = 0; idx < ids.length; ++idx) {
            int base = 0;
            BytesRef id = new BytesRef((CharSequence)ids[idx]);
            for (int subIDX = 0; subIDX < subReaders.size(); ++subIDX) {
                int docID;
                DocsEnum docs;
                AtomicReader sub = ((AtomicReaderContext)subReaders.get(subIDX)).reader();
                TermsEnum termsEnum = termsEnums[subIDX];
                if (termsEnum.seekExact(id, false) && (docs = (docsEnums[subIDX] = termsEnum.docs(sub.getLiveDocs(), docsEnums[subIDX], 0))) != null && (docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                    results[idx] = base + docID;
                    continue block2;
                }
                base += sub.maxDoc();
            }
        }
        return results;
    }

    public abstract IndexWriter writer();
}

