/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.index.directory;

import java.io.File;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryFactory;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryType;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.model.KCluster;

@RunWith(value=MockitoJUnitRunner.class)
public class DirectoryFactoryTest {
    DirectoryFactory factory;
    @Mock
    DirectoryType type;
    @Mock
    Analyzer analyzer;
    @Mock
    File hostingDir;
    @Mock
    File spaceDir;
    @Mock
    File projectDir;

    @Before
    public void setup() {
        Mockito.when((Object)this.hostingDir.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.hostingDir.listFiles()).thenReturn((Object)new File[]{this.spaceDir});
        Mockito.when((Object)this.spaceDir.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.spaceDir.listFiles()).thenReturn((Object)new File[]{this.projectDir});
        Mockito.when((Object)this.spaceDir.getName()).thenReturn((Object)"myteam");
        Mockito.when((Object)this.projectDir.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.projectDir.getName()).thenReturn((Object)"myproject");
        Mockito.when((Object)this.projectDir.getParentFile()).thenReturn((Object)this.spaceDir);
        Mockito.when((Object)this.type.newIndex((KCluster)Matchers.any(), (IndexWriterConfig)Matchers.any())).thenReturn(Mockito.mock(LuceneIndex.class));
        this.factory = new DirectoryFactory(this.type, this.analyzer, this.hostingDir);
    }

    @Test(expected=IllegalStateException.class)
    public void loadsExistingIndicesOnStartup() throws Exception {
        KClusterImpl kcluster = new KClusterImpl("myteam/myproject");
        this.factory.newCluster((KCluster)kcluster);
    }
}

