/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.index.directory;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DeleteCommand;
import org.uberfire.ext.metadata.backend.lucene.index.directory.Directory;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryFactory;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryLuceneIndex;
import org.uberfire.ext.metadata.model.KCluster;

public enum DirectoryType {
    INMEMORY{

        @Override
        public LuceneIndex newIndex(KCluster cluster, IndexWriterConfig config) {
            Directory directory = new Directory((org.apache.lucene.store.Directory)new RAMDirectory(), new DeleteCommand(){

                @Override
                public void execute(org.apache.lucene.store.Directory directory) {
                }
            }, true);
            return new DirectoryLuceneIndex(cluster, directory, config);
        }
    }
    ,
    NIO{

        @Override
        public LuceneIndex newIndex(KCluster cluster, IndexWriterConfig config) {
            NIOFSDirectory luceneDir;
            final File clusterDir = DirectoryType.clusterDir(cluster.getClusterId());
            try {
                luceneDir = new NIOFSDirectory(clusterDir.toPath());
            }
            catch (IOException e) {
                throw new org.uberfire.java.nio.IOException((Exception)e);
            }
            Directory directory = new Directory((org.apache.lucene.store.Directory)luceneDir, new DeleteCommand(){

                @Override
                public void execute(org.apache.lucene.store.Directory directory) {
                    DirectoryType.close((FSDirectory)((NIOFSDirectory)directory));
                    FileDeleteStrategy.FORCE.deleteQuietly(clusterDir);
                }
            }, DirectoryType.freshIndex(clusterDir));
            return new DirectoryLuceneIndex(cluster, directory, config);
        }
    }
    ,
    MMAP{

        @Override
        public LuceneIndex newIndex(KCluster cluster, IndexWriterConfig config) {
            MMapDirectory luceneDir;
            final File clusterDir = DirectoryType.clusterDir(cluster.getClusterId());
            try {
                luceneDir = new MMapDirectory(clusterDir.toPath());
            }
            catch (IOException e) {
                throw new org.uberfire.java.nio.IOException((Exception)e);
            }
            Directory directory = new Directory((org.apache.lucene.store.Directory)luceneDir, new DeleteCommand(){

                @Override
                public void execute(org.apache.lucene.store.Directory directory) {
                    DirectoryType.close((FSDirectory)((MMapDirectory)directory));
                    FileDeleteStrategy.FORCE.deleteQuietly(clusterDir);
                }
            }, DirectoryType.freshIndex(clusterDir));
            return new DirectoryLuceneIndex(cluster, directory, config);
        }
    };

    private static Logger logger;

    private static void close(FSDirectory directory) {
        try {
            directory.close();
        }
        catch (IOException e) {
            logger.warn("Can't close directory", (Throwable)e);
        }
    }

    private static File clusterDir(String clusterId) {
        return new File(DirectoryFactory.defaultHostingDir(), clusterId);
    }

    private static boolean freshIndex(File clusterDir) {
        return !clusterDir.exists();
    }

    public abstract LuceneIndex newIndex(KCluster var1, IndexWriterConfig var2);

    static {
        logger = LoggerFactory.getLogger(DirectoryType.class);
    }
}

