/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.provider;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.backend.lucene.fields.FieldFactory;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexManager;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.engine.IndexManager;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.ext.metadata.search.ClusterSegment;

public class LuceneIndexProvider
implements IndexProvider {
    private final FieldFactory fieldFactory;
    private IndexManager indexManager;

    public LuceneIndexProvider(IndexManager indexManager, FieldFactory fieldFactory) {
        this.indexManager = indexManager;
        this.fieldFactory = fieldFactory;
    }

    public boolean isFreshIndex(KCluster cluster) {
        Index index = this.indexManager.get(cluster);
        return index == null || index.freshIndex();
    }

    public void index(KObject object) {
        LuceneIndex index = (LuceneIndex)this.indexManager.indexOf((KObjectKey)object);
        index.indexDocument(object.getId(), this.newDocument(object));
        index.commit();
    }

    public void index(List<KObject> elements) {
        elements.forEach(ko -> {
            LuceneIndex index = (LuceneIndex)this.indexManager.indexOf((KObjectKey)ko);
            index.indexDocument(ko.getId(), this.newDocument((KObject)ko));
        });
        elements.stream().map(ko -> (LuceneIndex)this.indexManager.indexOf((KObjectKey)ko)).collect(Collectors.toSet()).forEach(luceneIndex -> luceneIndex.commit());
    }

    public boolean exists(String index, String id) {
        return this.findById(index, id).size() > 0;
    }

    public void delete(String index) {
        this.indexManager.delete(() -> index);
    }

    public void delete(String index, String id) {
        LuceneIndex luceneIndex = (LuceneIndex)this.indexManager.get((KCluster)new KClusterImpl(index));
        luceneIndex.deleteIfExists(id);
        luceneIndex.commit();
    }

    public List<KObject> findById(String index, String id) {
        List<String> indices = Arrays.asList(index);
        ScoreDoc[] docs = this.findRawByQuery(indices, (Query)new TermQuery(new Term("id", id)), null, 0);
        return Arrays.stream(docs).map(scoreDoc -> this.createKObject(indices, (ScoreDoc)scoreDoc)).collect(Collectors.toList());
    }

    public void rename(String index, String id, KObject to) {
        PortablePreconditions.checkNotNull((String)"from", (Object)index);
        PortablePreconditions.checkNotNull((String)"to", (Object)to);
        PortablePreconditions.checkCondition((String)"renames are allowed only from same cluster", (boolean)index.equals(to.getClusterId()));
        LuceneIndex luceneIndex = (LuceneIndex)this.indexManager.get((KCluster)new KClusterImpl(index));
        luceneIndex.rename(id, this.newDocument(to));
    }

    public long getIndexSize(String index) {
        LuceneIndex luceneIndex = (LuceneIndex)this.indexManager.get((KCluster)new KClusterImpl(index));
        return luceneIndex.nrtReader().numDocs();
    }

    public List<KObject> findByQuery(List<String> indices, Query query, int limit) {
        ScoreDoc[] docs = this.findRawByQuery(indices, query, null, 0);
        return Arrays.stream(docs).map(scoreDoc -> this.createKObject(indices, (ScoreDoc)scoreDoc)).collect(Collectors.toList());
    }

    public List<KObject> findByQuery(List<String> indices, Query query, Sort sort, int limit) {
        ScoreDoc[] docs = this.findRawByQuery(indices, query, sort, 0);
        return Arrays.stream(docs).map(scoreDoc -> this.createKObject(indices, (ScoreDoc)scoreDoc)).collect(Collectors.toList());
    }

    private KObject createKObject(List<String> indices, ScoreDoc scoreDoc) {
        try {
            IndexSearcher searcher = ((LuceneIndexManager)this.indexManager).getIndexSearcher(this.toClusterSegments(indices));
            return KObjectUtil.toKObject(searcher.doc(scoreDoc.doc));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert document to KObject");
        }
    }

    public long findHitsByQuery(List<String> indices, Query query) {
        return this.findRawByQuery(indices, query, null, 0).length;
    }

    public List<String> getIndices() {
        return this.indexManager.getIndices();
    }

    public ScoreDoc[] findRawByQuery(List<String> indices, Query query, Sort sort, int limit) {
        try {
            ClusterSegment[] clusterSegments = this.toClusterSegments(indices);
            IndexSearcher searcher = ((LuceneIndexManager)this.indexManager).getIndexSearcher(clusterSegments);
            int n = Integer.MAX_VALUE;
            if (limit > 0) {
                n = limit;
            }
            Object topDocs = sort != null ? searcher.search(query, n, sort) : searcher.search(query, n);
            return topDocs.scoreDocs;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ScoreDoc[0];
        }
    }

    private ClusterSegment[] toClusterSegments(List<String> indices) {
        return (ClusterSegment[])indices.stream().map(index -> new ClusterSegment((String)index){
            final /* synthetic */ String val$index;
            {
                this.val$index = string;
            }

            public String getClusterId() {
                return this.val$index;
            }

            public String[] segmentIds() {
                return new String[0];
            }
        }).toArray(ClusterSegment[]::new);
    }

    public void dispose() {
    }

    private Document newDocument(KObject object) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", object.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField("type", object.getType().getName(), Field.Store.YES));
        doc.add((IndexableField)new TextField("key", object.getKey(), Field.Store.YES));
        doc.add((IndexableField)new StringField("cluster.id", object.getClusterId(), Field.Store.YES));
        doc.add((IndexableField)new StringField("segment.id", object.getSegmentId(), Field.Store.YES));
        StringBuilder allText = new StringBuilder(object.getKey()).append('\n');
        for (KProperty property : object.getProperties()) {
            IndexableField[] fields;
            for (IndexableField field : fields = this.fieldFactory.build(property)) {
                doc.add(field);
                if (!(field instanceof TextField) || property.getValue() instanceof Boolean) continue;
                allText.append(field.stringValue()).append('\n');
            }
        }
        if (object.fullText()) {
            doc.add((IndexableField)new TextField("fullText", allText.toString().toLowerCase(), Field.Store.NO));
        }
        return doc;
    }
}

