/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.index.directory;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.assertj.core.api.Java6Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryFactory;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryType;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.model.KCluster;

@RunWith(value=MockitoJUnitRunner.class)
public class DirectoryFactoryTest {
    DirectoryFactory factory;
    @Mock
    DirectoryType type;
    @Mock
    Analyzer analyzer;
    @Mock
    File hostingDir;
    @Mock
    File spaceDir;
    @Mock
    File projectDir;
    @Mock
    File masterBranchDir;
    @Mock
    File developBranchDir;

    @Before
    public void setup() {
        Mockito.when((Object)this.hostingDir.listFiles()).thenReturn((Object)new File[]{this.spaceDir});
        Mockito.when((Object)this.spaceDir.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.spaceDir.listFiles()).thenReturn((Object)new File[]{this.projectDir});
        Mockito.when((Object)this.spaceDir.getName()).thenReturn((Object)"myteam");
        Mockito.when((Object)this.projectDir.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.projectDir.listFiles()).thenReturn((Object)new File[]{this.masterBranchDir, this.developBranchDir});
        Mockito.when((Object)this.projectDir.getName()).thenReturn((Object)"myproject");
        Mockito.when((Object)this.projectDir.getParentFile()).thenReturn((Object)this.spaceDir);
        Mockito.when((Object)this.masterBranchDir.getName()).thenReturn((Object)"master");
        Mockito.when((Object)this.masterBranchDir.getParentFile()).thenReturn((Object)this.projectDir);
        Mockito.when((Object)this.developBranchDir.getName()).thenReturn((Object)"develop");
        Mockito.when((Object)this.developBranchDir.getParentFile()).thenReturn((Object)this.projectDir);
        Mockito.when((Object)this.type.newIndex((KCluster)ArgumentMatchers.any(), (IndexWriterConfig)ArgumentMatchers.any())).thenReturn(Mockito.mock(LuceneIndex.class));
        this.factory = new DirectoryFactory(this.type, this.analyzer, this.hostingDir);
    }

    @Test(expected=IllegalStateException.class)
    public void loadsExistingIndicesOnStartup() throws Exception {
        KClusterImpl kcluster = new KClusterImpl("myteam/myproject/master");
        this.factory.newCluster((KCluster)kcluster);
    }

    @Test
    public void testClusterIdOf() {
        String clusterId = DirectoryFactory.clusterIdOf((File)this.masterBranchDir);
        Java6Assertions.assertThat((String)clusterId).isEqualTo("myteam/myproject/master");
    }

    @Test
    public void testLoadIndexes() {
        this.factory.loadIndexes(this.type, this.analyzer, this.hostingDir);
        List indexes = this.factory.getIndexes().keySet().stream().map(KCluster::getClusterId).collect(Collectors.toList());
        Java6Assertions.assertThat(indexes).containsExactly((Object[])new String[]{"myteam/myproject/master", "myteam/myproject/develop"});
    }
}

