/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexFactory;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.engine.IndexManager;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.ext.metadata.search.ClusterSegment;

public class LuceneIndexManager
implements IndexManager {
    private final LuceneIndexFactory factory;
    private final Map<KCluster, LuceneIndex> indexes = new ConcurrentHashMap<KCluster, LuceneIndex>();

    public LuceneIndexManager(LuceneIndexFactory factory) {
        this.factory = (LuceneIndexFactory)PortablePreconditions.checkNotNull((String)"factory", (Object)factory);
        this.indexes.putAll(factory.getIndexes());
    }

    public boolean contains(KCluster cluster) {
        return this.indexes.containsKey(cluster);
    }

    public synchronized LuceneIndex indexOf(KObjectKey object) {
        KCluster kcluster = this.kcluster(object);
        LuceneIndex currentSetup = this.indexes.get(kcluster);
        if (currentSetup != null) {
            return currentSetup;
        }
        LuceneIndex index = this.factory.newCluster(kcluster);
        this.indexes.put(kcluster, index);
        return index;
    }

    public KCluster kcluster(KObjectKey object) {
        return new KClusterImpl(object.getClusterId());
    }

    public void delete(KCluster cluster) {
        LuceneIndex setup = this.indexes.remove(cluster);
        this.factory.remove(cluster);
        if (setup != null) {
            setup.delete();
        } else {
            this.deleteProjectIndexes(cluster);
        }
    }

    protected void deleteProjectIndexes(KCluster cluster) {
        List<KCluster> clusters = ((Stream)this.indexes.keySet().stream().parallel()).filter(s -> s.getClusterId().startsWith(cluster.getClusterId())).collect(Collectors.toList());
        clusters.forEach(cl -> {
            LuceneIndex setup = this.indexes.remove(cl);
            this.factory.remove((KCluster)cl);
            if (setup != null) {
                setup.delete();
            }
        });
    }

    public void dispose() {
        for (LuceneIndex index : this.indexes.values()) {
            index.dispose();
        }
        this.factory.dispose();
    }

    public Index get(KCluster cluster) {
        return this.indexes.get(cluster);
    }

    /*
     * WARNING - void declaration
     */
    public IndexSearcher getIndexSearcher(ClusterSegment ... clusterSegments) {
        HashSet<Object> clusters;
        if (clusterSegments == null || clusterSegments.length == 0) {
            clusters = new HashSet<KCluster>(this.indexes.keySet());
        } else {
            void var5_8;
            clusters = new HashSet(clusterSegments.length);
            ClusterSegment[] clusterSegmentArray = clusterSegments;
            int n = clusterSegmentArray.length;
            boolean bl = false;
            while (var5_8 < n) {
                ClusterSegment clusterSegment = clusterSegmentArray[var5_8];
                clusters.add(new KClusterImpl(clusterSegment.getClusterId()));
                ++var5_8;
            }
        }
        ArrayList<IndexReader> readers = new ArrayList<IndexReader>(clusters.size());
        for (KCluster kCluster : clusters) {
            LuceneIndex index = this.indexes.get(kCluster);
            readers.add(index.nrtReader());
        }
        try {
            return new SearcherFactory().newSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[readers.size()])), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void release(IndexSearcher index) {
        try {
            index.getIndexReader().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getIndices() {
        return this.indexes.keySet().stream().map(kCluster -> kCluster.getClusterId()).collect(Collectors.toList());
    }
}

