/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.fest.assertions.api.Assertions;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.AbstractBaseTest;
import org.uberfire.java.nio.file.FileTreeWalker;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@Ignore
public class FileTreeWalkerTest
extends AbstractBaseTest {
    final AtomicInteger preDir = new AtomicInteger();
    final AtomicInteger postDir = new AtomicInteger();
    final AtomicInteger fileC = new AtomicInteger();
    final AtomicInteger failFile = new AtomicInteger();
    final FileVisitor<Path> simple = new FileVisitor<Path>(){

        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            FileTreeWalkerTest.this.preDir.addAndGet(1);
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            FileTreeWalkerTest.this.fileC.addAndGet(1);
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            FileTreeWalkerTest.this.failFile.addAndGet(1);
            return FileVisitResult.TERMINATE;
        }

        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            FileTreeWalkerTest.this.postDir.addAndGet(1);
            return FileVisitResult.CONTINUE;
        }
    };

    @Override
    @After
    public void cleanup() throws java.io.IOException {
        for (File file : this.cleanupList) {
            FileUtils.deleteDirectory((File)file);
        }
    }

    @Test
    public void testWalker() {
        FileTreeWalker walker = new FileTreeWalker(this.simple, 1);
        walker.walk(Paths.get((String)"/some/path", (String[])new String[0]));
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(0);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(0);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(0);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(1);
        Path dir = this.newTempDir(null);
        Path file1 = Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Path file2 = Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.cleanupVisitor();
        walker.walk(dir);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(1);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(1);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(2);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
        this.cleanupVisitor();
        walker.walk(file1);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(0);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(0);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(1);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    @Test
    public void testWalkerDeep2() {
        FileTreeWalker walker = new FileTreeWalker(this.simple, 2);
        Path dir = this.newTempDir(null);
        Path subDir = this.newTempDir(dir);
        Path subSubDir = this.newTempDir(subDir);
        Path subSubSubDir = this.newTempDir(subSubDir);
        this.cleanupVisitor();
        walker.walk(dir);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(2);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(2);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(1);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    @Test
    public void testWalkerDeep1() {
        FileTreeWalker walker = new FileTreeWalker(this.simple, 1);
        Path dir = this.newTempDir(null);
        Path subDir = this.newTempDir(dir);
        Path subSubDir = this.newTempDir(subDir);
        Path subSubSubDir = this.newTempDir(subSubDir);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.cleanupVisitor();
        walker.walk(dir);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(1);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(1);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(3);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    @Test
    public void testWalkerDeep2ButTerminateOnDir() {
        FileVisitor<Path> terminateOnDir = new FileVisitor<Path>(){

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileTreeWalkerTest.this.preDir.addAndGet(1);
                if (FileTreeWalkerTest.this.preDir.get() > 1) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileTreeWalkerTest.this.fileC.addAndGet(1);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                FileTreeWalkerTest.this.failFile.addAndGet(1);
                return FileVisitResult.TERMINATE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileTreeWalkerTest.this.postDir.addAndGet(1);
                return FileVisitResult.CONTINUE;
            }
        };
        FileTreeWalker walker = new FileTreeWalker((FileVisitor)terminateOnDir, 2);
        Path dir = this.newTempDir(null);
        Path subDir = this.newTempDir(dir);
        Path subSubDir = this.newTempDir(subDir);
        Path subSubSubDir = this.newTempDir(subSubDir);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.cleanupVisitor();
        walker.walk(dir);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(2);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(0);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(2);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    @Test
    public void testWalkerDeep2ButSkipSibling() {
        FileVisitor<Path> terminateOnDir = new FileVisitor<Path>(){

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileTreeWalkerTest.this.preDir.addAndGet(1);
                if (FileTreeWalkerTest.this.preDir.get() > 1) {
                    return FileVisitResult.SKIP_SIBLINGS;
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileTreeWalkerTest.this.fileC.addAndGet(1);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                FileTreeWalkerTest.this.failFile.addAndGet(1);
                return FileVisitResult.TERMINATE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileTreeWalkerTest.this.postDir.addAndGet(1);
                return FileVisitResult.CONTINUE;
            }
        };
        FileTreeWalker walker = new FileTreeWalker((FileVisitor)terminateOnDir, 2);
        Path dir = this.newTempDir(null);
        Path subDir1 = this.newTempDir(dir);
        Path subDir2 = this.newTempDir(dir);
        Path subDir3 = this.newTempDir(dir);
        Path subDir4 = this.newTempDir(dir);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.cleanupVisitor();
        walker.walk(dir);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(2);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(1);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(2);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    @Test
    public void testWalkerDeep2ButThrowExceptionOnSibling() {
        FileVisitor<Path> terminateOnDir = new FileVisitor<Path>(){

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileTreeWalkerTest.this.preDir.addAndGet(1);
                if (FileTreeWalkerTest.this.preDir.get() > 1) {
                    throw new IOException();
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileTreeWalkerTest.this.fileC.addAndGet(1);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                FileTreeWalkerTest.this.failFile.addAndGet(1);
                return FileVisitResult.TERMINATE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileTreeWalkerTest.this.postDir.addAndGet(1);
                if (exc == null) {
                    throw new RuntimeException();
                }
                return FileVisitResult.CONTINUE;
            }
        };
        FileTreeWalker walker = new FileTreeWalker((FileVisitor)terminateOnDir, 2);
        Path dir = this.newTempDir(null);
        Path subDir1 = this.newTempDir(dir);
        Path subDir2 = this.newTempDir(dir);
        Path subDir3 = this.newTempDir(dir);
        Path subDir4 = this.newTempDir(dir);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.cleanupVisitor();
        walker.walk(dir);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(2);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(1);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(2);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    @Test
    public void testWalkerDeep2ButReturnNull() {
        FileVisitor<Path> terminateOnDir = new FileVisitor<Path>(){

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileTreeWalkerTest.this.preDir.addAndGet(1);
                if (FileTreeWalkerTest.this.preDir.get() > 1) {
                    return null;
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileTreeWalkerTest.this.fileC.addAndGet(1);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                FileTreeWalkerTest.this.failFile.addAndGet(1);
                return null;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileTreeWalkerTest.this.postDir.addAndGet(1);
                if (exc == null) {
                    throw new RuntimeException();
                }
                return FileVisitResult.CONTINUE;
            }
        };
        FileTreeWalker walker = new FileTreeWalker((FileVisitor)terminateOnDir, 2);
        Path dir = this.newTempDir(null);
        Path subDir1 = this.newTempDir(dir);
        Path subDir2 = this.newTempDir(dir);
        Path subDir3 = this.newTempDir(dir);
        Path subDir4 = this.newTempDir(dir);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.cleanupVisitor();
        walker.walk(dir);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(2);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(0);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(2);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    private void cleanupVisitor() {
        this.preDir.set(0);
        this.postDir.set(0);
        this.fileC.set(0);
        this.failFile.set(0);
    }
}

