/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ObjectAssert;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.BaseSimpleFileSystem;

public class FileSystemsTest {
    @Test
    public void testGetDefault() {
        ((ObjectAssert)Assertions.assertThat((Object)FileSystems.getDefault()).isNotNull()).isInstanceOf(BaseSimpleFileSystem.class);
    }

    @Test
    public void testGetFileSystemByURI() {
        ((ObjectAssert)Assertions.assertThat((Object)FileSystems.getFileSystem((URI)URI.create("default:///"))).isNotNull()).isInstanceOf(BaseSimpleFileSystem.class);
        ((ObjectAssert)Assertions.assertThat((Object)FileSystems.getFileSystem((URI)URI.create("file:///"))).isNotNull()).isInstanceOf(BaseSimpleFileSystem.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileSystemNull() {
        FileSystems.getFileSystem(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull1() {
        Map emptyMap = Collections.emptyMap();
        FileSystems.newFileSystem(null, emptyMap);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull2() {
        FileSystems.newFileSystem((URI)URI.create("jgit:///test"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull3() {
        FileSystems.newFileSystem((URI)null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull4() {
        FileSystems.newFileSystem((Path)null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull5() {
        FileSystems.newFileSystem((URI)URI.create("jgit:///test"), null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull6() {
        FileSystems.newFileSystem((URI)URI.create("jgit:///test"), null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull7() {
        FileSystems.newFileSystem(null, null, null);
    }
}

