/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Assume;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.BasicFileAttributesImpl;
import org.uberfire.java.nio.base.NotImplementedException;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AbstractBaseTest;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class FilesTest
extends AbstractBaseTest {
    @Test
    public void newIOStreams() throws java.io.IOException {
        Path dir = this.newTempDir();
        try (OutputStream out = Files.newOutputStream((Path)dir.resolve("file.txt"), (OpenOption[])new OpenOption[0]);){
            AssertionsForClassTypes.assertThat((Object)out).isNotNull();
            out.write("content".getBytes());
        }
        var3_3 = null;
        try (InputStream in = Files.newInputStream((Path)dir.resolve("file.txt"), (OpenOption[])new OpenOption[0]);){
            int i;
            AssertionsForClassTypes.assertThat((InputStream)in).isNotNull();
            StringBuilder sb = new StringBuilder();
            while ((i = in.read()) != -1) {
                sb.append((char)i);
            }
            AssertionsForClassTypes.assertThat((String)sb.toString()).isEqualTo((Object)"content");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void newInputStreamNonExistent() {
        Assertions.assertThatThrownBy(() -> Files.newInputStream((Path)Paths.get((String)"/path/to/some/file.txt", (String[])new String[0]), (OpenOption[])new OpenOption[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void newInputStreamOnDir() {
        Path dir = this.newTempDir();
        Assertions.assertThatThrownBy(() -> Files.newInputStream((Path)dir, (OpenOption[])new OpenOption[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void newInputStreamNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newInputStream(null, (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void newOutputStreamOnExistent() {
        Path dir = this.newTempDir();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newOutputStream((Path)dir, (OpenOption[])new OpenOption[0])).isInstanceOf(IOException.class)).hasMessage("Could not open output stream.");
    }

    @Test
    public void newOutpurStreamNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newOutputStream(null, (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void newByteChannel() throws java.io.IOException {
        try (SeekableByteChannel sbc = Files.newByteChannel((Path)this.newTempDir().resolve("file.temp.txt"), new HashSet(), (FileAttribute[])new FileAttribute[0]);){
            AssertionsForClassTypes.assertThat((Object)sbc).isNotNull();
        }
        var2_2 = null;
        try (SeekableByteChannel sbc2 = Files.newByteChannel((Path)this.newTempDir().resolve("file.temp2.txt"), (OpenOption[])new OpenOption[0]);){
            AssertionsForClassTypes.assertThat((Object)sbc2).isNotNull();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void newByteChannelFileAlreadyExists() {
        Assertions.assertThatThrownBy(() -> Files.newByteChannel((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0])).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    public void newByteChannelNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newByteChannel(null, (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void createFile() {
        Path path = Files.createFile((Path)this.newTempDir().resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((File)path.toFile()).exists();
    }

    @Test
    public void createFileAlreadyExists() {
        Assertions.assertThatThrownBy(() -> Files.createFile((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (FileAttribute[])new FileAttribute[0])).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    public void createFileNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.createFile(null, (FileAttribute[])new FileAttribute[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void createDirectory() {
        Path path = this.newTempDir();
        Path dir = Files.createDirectory((Path)path.resolve("myNewDir"), (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)dir).isNotNull();
        AssertionsForClassTypes.assertThat((File)dir.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)dir.toFile()).isDirectory();
        Path file = Files.createFile((Path)dir.resolve("new.file.txt"), (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)file).isNotNull();
        AssertionsForClassTypes.assertThat((File)file.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)file.toFile()).isFile();
    }

    @Test
    public void createDirectoryFileAlreadyExists() {
        Assertions.assertThatThrownBy(() -> Files.createDirectory((Path)this.newTempDir(), (FileAttribute[])new FileAttribute[0])).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    public void createDirectoryNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.createDirectory(null, (FileAttribute[])new FileAttribute[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'dir' should be not null!");
    }

    @Test
    public void createDirectories() {
        Path path = this.newTempDir();
        Path dir = Files.createDirectories((Path)path.resolve("myNewDir/mysubDir1/mysubDir2"), (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)dir).isNotNull();
        AssertionsForClassTypes.assertThat((File)dir.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)dir.toFile()).isDirectory();
        Path file = Files.createFile((Path)dir.resolve("new.file.txt"), (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)file).isNotNull();
        AssertionsForClassTypes.assertThat((File)file.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)file.toFile()).isFile();
    }

    @Test
    public void createDirectoriesFileAlreadyExists() {
        Assertions.assertThatThrownBy(() -> Files.createDirectories((Path)this.newTempDir(), (FileAttribute[])new FileAttribute[0])).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    public void createDirectoriesNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.createDirectories(null, (FileAttribute[])new FileAttribute[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'dir' should be not null!");
    }

    @Test
    public void delete() {
        Path path = Files.createFile((Path)this.newTempDir().resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((File)path.toFile()).exists();
        Files.delete((Path)path, (DeleteOption[])new DeleteOption[0]);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((File)path.toFile()).doesNotExist();
        Path dir = this.newTempDir();
        AssertionsForClassTypes.assertThat((Object)dir).isNotNull();
        AssertionsForClassTypes.assertThat((File)dir.toFile()).exists();
        Files.delete((Path)dir, (DeleteOption[])new DeleteOption[0]);
        AssertionsForClassTypes.assertThat((Object)dir).isNotNull();
        AssertionsForClassTypes.assertThat((File)dir.toFile()).doesNotExist();
    }

    @Test
    public void deleteDirectoryNotEmpty() {
        Path dir = this.newTempDir();
        Files.createFile((Path)dir.resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.delete((Path)dir, (DeleteOption[])new DeleteOption[0])).isInstanceOf(DirectoryNotEmptyException.class);
    }

    @Test
    public void deleteNoSuchFileException() {
        Assertions.assertThatThrownBy(() -> Files.delete((Path)this.newTempDir().resolve("file.temp.txt"), (DeleteOption[])new DeleteOption[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void deleteNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.delete(null, (DeleteOption[])new DeleteOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void deleteIfExists() {
        Path path = Files.createFile((Path)this.newTempDir().resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((File)path.toFile()).exists();
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)path, (DeleteOption[])new DeleteOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((File)path.toFile()).doesNotExist();
        Path dir = this.newTempDir();
        AssertionsForClassTypes.assertThat((Object)dir).isNotNull();
        AssertionsForClassTypes.assertThat((File)dir.toFile()).exists();
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)dir, (DeleteOption[])new DeleteOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((Object)dir).isNotNull();
        AssertionsForClassTypes.assertThat((File)dir.toFile()).doesNotExist();
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)this.newTempDir().resolve("file.temp.txt"), (DeleteOption[])new DeleteOption[0])).isFalse();
    }

    @Test
    public void deleteIfExistsDirectoryNotEmpty() {
        Path dir = this.newTempDir();
        Files.createFile((Path)dir.resolve("file.temp.txt"), (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.deleteIfExists((Path)dir, (DeleteOption[])new DeleteOption[0])).isInstanceOf(DirectoryNotEmptyException.class);
    }

    @Test
    public void deleteIfExistsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.deleteIfExists(null, (DeleteOption[])new DeleteOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void createTempFile() {
        Path tempFile = Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile).isNotNull();
        AssertionsForClassTypes.assertThat((String)tempFile.getFileName().toString()).endsWith((CharSequence)"tmp");
        AssertionsForClassTypes.assertThat((File)tempFile.toFile()).exists();
        Path tempFile2 = Files.createTempFile((String)"", (String)"", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile2).isNotNull();
        AssertionsForClassTypes.assertThat((String)tempFile2.getFileName().toString()).endsWith((CharSequence)"tmp");
        AssertionsForClassTypes.assertThat((File)tempFile2.toFile()).exists();
        Path tempFile3 = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile3).isNotNull();
        AssertionsForClassTypes.assertThat((File)tempFile3.toFile()).exists();
        AssertionsForClassTypes.assertThat((String)tempFile3.getFileName().toString()).startsWith((CharSequence)"foo").endsWith((CharSequence)".bar");
        Path tempFile4 = Files.createTempFile((String)"", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile4).isNotNull();
        AssertionsForClassTypes.assertThat((File)tempFile4.toFile()).exists();
        AssertionsForClassTypes.assertThat((String)tempFile4.getFileName().toString()).endsWith((CharSequence)".bar");
        Path tempFile5 = Files.createTempFile((String)"", (String)".bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile5).isNotNull();
        AssertionsForClassTypes.assertThat((File)tempFile5.toFile()).exists();
        AssertionsForClassTypes.assertThat((String)tempFile5.getFileName().toString()).endsWith((CharSequence)".bar");
        Path tempFile6 = Files.createTempFile((String)"", (String)"bar.temp", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile6).isNotNull();
        AssertionsForClassTypes.assertThat((File)tempFile6.toFile()).exists();
        AssertionsForClassTypes.assertThat((String)tempFile6.getFileName().toString()).endsWith((CharSequence)".bar.temp");
        Path tempFile7 = Files.createTempFile((String)"", (String)".bar.temp", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile7).isNotNull();
        AssertionsForClassTypes.assertThat((File)tempFile7.toFile()).exists();
        AssertionsForClassTypes.assertThat((String)tempFile7.getFileName().toString()).endsWith((CharSequence)".bar.temp");
    }

    @Test
    public void createTempFileInsideDir() {
        Path dir = this.newTempDir();
        AssertionsForClassTypes.assertThat((Object[])dir.toFile().list()).isEmpty();
        Path tempFile = Files.createTempFile((Path)dir, null, null, (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile).isNotNull();
        AssertionsForClassTypes.assertThat((String)tempFile.getFileName().toString()).endsWith((CharSequence)"tmp");
        AssertionsForClassTypes.assertThat((File)tempFile.toFile()).exists();
        AssertionsForClassTypes.assertThat((Object[])dir.toFile().list()).isNotEmpty();
    }

    @Test
    public void createTempFileNoSuchFile() {
        Assertions.assertThatThrownBy(() -> Files.createTempFile((Path)Paths.get((String)"/path/to/", (String[])new String[0]), null, null, (FileAttribute[])new FileAttribute[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void createTempFileNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.createTempFile((Path)null, null, null, (FileAttribute[])new FileAttribute[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'dir' should be not null!");
    }

    @Test
    public void createTempDirectory() {
        Path tempFile = Files.createTempDirectory(null, (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile).isNotNull();
        AssertionsForClassTypes.assertThat((File)tempFile.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)tempFile.toFile()).isDirectory();
        Path tempFile2 = Files.createTempDirectory((String)"", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile2).isNotNull();
        AssertionsForClassTypes.assertThat((File)tempFile2.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)tempFile2.toFile()).isDirectory();
        Path tempFile3 = Files.createTempDirectory((String)"foo", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile3).isNotNull();
        AssertionsForClassTypes.assertThat((File)tempFile3.toFile()).exists();
        AssertionsForClassTypes.assertThat((String)tempFile3.getFileName().toString()).startsWith((CharSequence)"foo");
        AssertionsForClassTypes.assertThat((File)tempFile3.toFile()).isDirectory();
    }

    @Test
    public void createTempDirectoryInsideDir() {
        Path dir = this.newTempDir();
        AssertionsForClassTypes.assertThat((Object[])dir.toFile().list()).isEmpty();
        Path tempFile = Files.createTempDirectory((Path)dir, null, (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)tempFile).isNotNull();
        AssertionsForClassTypes.assertThat((File)tempFile.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)tempFile.toFile()).isDirectory();
        AssertionsForClassTypes.assertThat((Object[])dir.toFile().list()).isNotEmpty();
    }

    @Test
    public void createTempDirectoryNoSuchFile() {
        Assertions.assertThatThrownBy(() -> Files.createTempDirectory((Path)Paths.get((String)"/path/to/", (String[])new String[0]), null, (FileAttribute[])new FileAttribute[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void createTempDirectoryNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.createTempDirectory((Path)null, null, (FileAttribute[])new FileAttribute[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'dir' should be not null!");
    }

    @Test
    public void copyDir() {
        Path source = this.newTempDir();
        Path dest = this.newDirToClean();
        AssertionsForClassTypes.assertThat((File)source.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)dest.toFile()).doesNotExist();
        Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        AssertionsForClassTypes.assertThat((File)dest.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)source.toFile()).exists();
    }

    @Test
    public void copyDirDirectoryNotEmptyException() {
        Path source = this.newTempDir();
        Path dest = this.newDirToClean();
        Files.createTempFile((Path)source, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0])).isInstanceOf(DirectoryNotEmptyException.class);
    }

    @Test
    public void copyFile() throws java.io.IOException {
        Path dir = this.newTempDir();
        Path source = dir.resolve("temp.txt");
        Path dest = dir.resolve("result.txt");
        try (OutputStream stream = Files.newOutputStream((Path)source, (OpenOption[])new OpenOption[0]);){
            stream.write(97);
        }
        Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        AssertionsForClassTypes.assertThat((File)dest.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)source.toFile()).exists();
        AssertionsForClassTypes.assertThat((long)dest.toFile().length()).isEqualTo(source.toFile().length());
    }

    @Test
    public void copyFileInvalidSourceAndTarget() throws java.io.IOException {
        Path source = this.newTempDir();
        Path dest = this.newTempDir().resolve("other");
        Path sourceFile = source.resolve("file.txt");
        try (OutputStream stream = Files.newOutputStream((Path)sourceFile, (OpenOption[])new OpenOption[0]);){
            stream.write(97);
        }
        Assertions.assertThatThrownBy(() -> Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0])).isInstanceOf(DirectoryNotEmptyException.class);
        sourceFile.toFile().delete();
        Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        Assertions.assertThatThrownBy(() -> Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0])).isInstanceOf(FileAlreadyExistsException.class);
        dest.toFile().delete();
        source.toFile().delete();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0])).isInstanceOf(IllegalStateException.class)).hasMessage("Condition 'source must exist' is invalid!");
    }

    @Test
    public void copyNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((Path)this.newTempDir(), (Path)null, (CopyOption[])new CopyOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'target' should be not null!");
    }

    @Test
    public void copyNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((Path)null, (Path)Paths.get((String)"/temp", (String[])new String[0]), (CopyOption[])new CopyOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'source' should be not null!");
    }

    @Test
    public void copyNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((Path)null, (Path)null, (CopyOption[])new CopyOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'source' should be not null!");
    }

    @Test
    public void moveDir() {
        Path source = this.newTempDir();
        Path dest = this.newTempDir().resolve("other");
        Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        AssertionsForClassTypes.assertThat((File)source.toFile()).doesNotExist();
        AssertionsForClassTypes.assertThat((File)dest.toFile()).exists();
    }

    @Test
    public void moveFile() throws java.io.IOException {
        Path dir = this.newTempDir();
        Path source = dir.resolve("fileSource.txt");
        Path dest = dir.resolve("fileDest.txt");
        try (OutputStream stream = Files.newOutputStream((Path)source, (OpenOption[])new OpenOption[0]);){
            stream.write(97);
        }
        long lenght = source.toFile().length();
        Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        AssertionsForClassTypes.assertThat((File)dest.toFile()).exists();
        AssertionsForClassTypes.assertThat((File)source.toFile()).doesNotExist();
        AssertionsForClassTypes.assertThat((long)dest.toFile().length()).isEqualTo(lenght);
    }

    @Test
    public void moveFileInvalidSourceAndTarget() throws java.io.IOException {
        Path source = this.newTempDir();
        Path dest = this.newTempDir().resolve("other");
        Path sourceFile = source.resolve("file.txt");
        try (OutputStream stream = Files.newOutputStream((Path)sourceFile, (OpenOption[])new OpenOption[0]);){
            stream.write(97);
        }
        Assertions.assertThatThrownBy(() -> Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0])).isInstanceOf(DirectoryNotEmptyException.class);
        sourceFile.toFile().delete();
        Files.copy((Path)source, (Path)dest, (CopyOption[])new CopyOption[0]);
        Assertions.assertThatThrownBy(() -> Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0])).isInstanceOf(FileAlreadyExistsException.class);
        dest.toFile().delete();
        source.toFile().delete();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.move((Path)source, (Path)dest, (CopyOption[])new CopyOption[0])).isInstanceOf(IllegalStateException.class)).hasMessage("Condition 'source must exist' is invalid!");
    }

    @Test
    public void moveNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.move((Path)this.newTempDir(), null, (CopyOption[])new CopyOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'target' should be not null!");
    }

    @Test
    public void moveNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.move(null, (Path)this.newTempDir(), (CopyOption[])new CopyOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'source' should be not null!");
    }

    @Test
    public void moveNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.move(null, null, (CopyOption[])new CopyOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'source' should be not null!");
    }

    @Test
    public void getFileStoreNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.getFileStore(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void getFileStoreN() {
        URI uri = URI.create("nothing:///testXXXXXXX");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.getFileStore((Path)Paths.get((URI)uri))).isInstanceOf(FileSystemNotFoundException.class)).hasMessage("Provider 'nothing' not found");
    }

    @Test
    public void getFileAttributeViewGeneral() {
        Path path = Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]);
        BasicFileAttributeView view = (BasicFileAttributeView)Files.getFileAttributeView((Path)path, BasicFileAttributeView.class, (LinkOption[])new LinkOption[0]);
        AssertionsForClassTypes.assertThat((Object)view).isNotNull();
        AssertionsForClassTypes.assertThat((Object)view.readAttributes()).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)view.readAttributes().isRegularFile()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)view.readAttributes().isDirectory()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)view.readAttributes().isSymbolicLink()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)view.readAttributes().isOther()).isFalse();
        AssertionsForClassTypes.assertThat((long)view.readAttributes().size()).isEqualTo(0L);
    }

    @Test
    public void getFileAttributeViewBasic() {
        Path path = Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]);
        BasicFileAttributeView view = (BasicFileAttributeView)Files.getFileAttributeView((Path)path, BasicFileAttributeView.class, (LinkOption[])new LinkOption[0]);
        AssertionsForClassTypes.assertThat((Object)view).isNotNull();
        AssertionsForClassTypes.assertThat((Object)view.readAttributes()).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)view.readAttributes().isRegularFile()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)view.readAttributes().isDirectory()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)view.readAttributes().isSymbolicLink()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)view.readAttributes().isOther()).isFalse();
        AssertionsForClassTypes.assertThat((long)view.readAttributes().size()).isEqualTo(0L);
    }

    @Test
    public void getFileAttributeViewInvalidView() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)Files.getFileAttributeView((Path)path, MyAttrsView.class, (LinkOption[])new LinkOption[0])).isNull();
    }

    @Test
    public void getFileAttributeViewNoSuchFileException() {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Assertions.assertThatThrownBy(() -> {
            BasicFileAttributeView cfr_ignored_0 = (BasicFileAttributeView)Files.getFileAttributeView((Path)path, BasicFileAttributeView.class, (LinkOption[])new LinkOption[0]);
        }).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void getFileAttributeViewNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            MyAttrsView cfr_ignored_0 = (MyAttrsView)Files.getFileAttributeView(null, MyAttrsView.class, (LinkOption[])new LinkOption[0]);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void getFileAttributeViewNull2() {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.getFileAttributeView((Path)path, null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'type' should be not null!");
    }

    @Test
    public void getFileAttributeViewNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.getFileAttributeView(null, null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAttributesGeneral() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        BasicFileAttributesImpl attrs = (BasicFileAttributesImpl)Files.readAttributes((Path)path, BasicFileAttributesImpl.class, (LinkOption[])new LinkOption[0]);
        AssertionsForClassTypes.assertThat((Object)attrs).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)attrs.isRegularFile()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)attrs.isDirectory()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)attrs.isSymbolicLink()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)attrs.isOther()).isFalse();
        AssertionsForClassTypes.assertThat((long)attrs.size()).isEqualTo(0L);
    }

    @Test
    public void readAttributesBasic() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        BasicFileAttributes attrs = Files.readAttributes((Path)path, BasicFileAttributes.class, (LinkOption[])new LinkOption[0]);
        AssertionsForClassTypes.assertThat((Object)attrs).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)attrs.isRegularFile()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)attrs.isDirectory()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)attrs.isSymbolicLink()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)attrs.isOther()).isFalse();
        AssertionsForClassTypes.assertThat((long)attrs.size()).isEqualTo(0L);
    }

    @Test
    public void readAttributesNonExistentFile() {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Assertions.assertThatThrownBy(() -> Files.readAttributes((Path)path, BasicFileAttributes.class, (LinkOption[])new LinkOption[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void readAttributesInvalid() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)Files.readAttributes((Path)path, MyAttrs.class, (LinkOption[])new LinkOption[0])).isNull();
    }

    @Test
    public void readAttributesNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            MyAttrs cfr_ignored_0 = (MyAttrs)Files.readAttributes(null, MyAttrs.class, (LinkOption[])new LinkOption[0]);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAttributesNull2() {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            MyAttrs cfr_ignored_0 = (MyAttrs)Files.readAttributes((Path)path, (Class)null, (LinkOption[])new LinkOption[0]);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'type' should be not null!");
    }

    @Test
    public void readAttributesNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            MyAttrs cfr_ignored_0 = (MyAttrs)Files.readAttributes(null, (Class)null, (LinkOption[])new LinkOption[0]);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAttributesMap() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"*", (LinkOption[])new LinkOption[0])).hasSize(9);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:*", (LinkOption[])new LinkOption[0])).hasSize(9);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:isRegularFile", (LinkOption[])new LinkOption[0])).hasSize(1);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:isRegularFile,isDirectory", (LinkOption[])new LinkOption[0])).hasSize(2);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:isRegularFile,isDirectory,someThing", (LinkOption[])new LinkOption[0])).hasSize(2);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"basic:someThing", (LinkOption[])new LinkOption[0])).hasSize(0);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"isRegularFile", (LinkOption[])new LinkOption[0])).hasSize(1);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"isRegularFile,isDirectory", (LinkOption[])new LinkOption[0])).hasSize(2);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"isRegularFile,isDirectory,someThing", (LinkOption[])new LinkOption[0])).hasSize(2);
        Assertions.assertThat((Map)Files.readAttributes((Path)path, (String)"someThing", (LinkOption[])new LinkOption[0])).hasSize(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAttributes((Path)path, (String)":someThing", (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage(":someThing");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAttributes((Path)path, (String)"advanced:isRegularFile", (LinkOption[])new LinkOption[0])).isInstanceOf(UnsupportedOperationException.class)).hasMessage("View 'advanced' not available");
    }

    @Test
    public void readAttributesMapNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAttributes(null, (String)"*", (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAttributesMapNull2() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAttributes((Path)path, (String)null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'attributes' should be filled!");
    }

    @Test
    public void readAttributesMapNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAttributes(null, (String)null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAttributesMapEmpty() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAttributes((Path)path, (String)"", (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'attributes' should be filled!");
    }

    @Test
    public void readAttributesMapNoSuchFileException() {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Assertions.assertThatThrownBy(() -> Files.readAttributes((Path)path, (String)"*", (LinkOption[])new LinkOption[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void setAttributeNull1() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.setAttribute((Path)path, null, null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'attribute' should be filled!");
    }

    @Test
    public void setAttributeNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.setAttribute(null, (String)"some", null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void setAttributeNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.setAttribute(null, null, null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void setAttributeEmpty() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.setAttribute((Path)path, (String)"", null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'attribute' should be filled!");
    }

    @Test
    public void setAttributeInvalidAttr() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.setAttribute((Path)path, (String)"myattr", null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalStateException.class)).hasMessage("Condition 'invalid attribute' is invalid!");
    }

    @Test
    public void setAttributeInvalidView() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.setAttribute((Path)path, (String)"advanced:isRegularFile", null, (LinkOption[])new LinkOption[0])).isInstanceOf(UnsupportedOperationException.class)).hasMessage("View 'advanced' not available");
    }

    @Test
    public void setAttributeInvalidView2() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.setAttribute((Path)path, (String)":isRegularFile", null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage(":isRegularFile");
    }

    @Test
    public void setAttributeNotImpl() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.setAttribute((Path)path, (String)"isRegularFile", null, (LinkOption[])new LinkOption[0])).isInstanceOf(NotImplementedException.class);
    }

    @Test
    public void readAttribute() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)Files.getAttribute((Path)path, (String)"basic:isRegularFile", (LinkOption[])new LinkOption[0])).isNotNull();
        AssertionsForClassTypes.assertThat((Object)Files.getAttribute((Path)path, (String)"basic:someThing", (LinkOption[])new LinkOption[0])).isNull();
        AssertionsForClassTypes.assertThat((Object)Files.getAttribute((Path)path, (String)"isRegularFile", (LinkOption[])new LinkOption[0])).isNotNull();
        AssertionsForClassTypes.assertThat((Object)Files.getAttribute((Path)path, (String)"someThing", (LinkOption[])new LinkOption[0])).isNull();
    }

    @Test
    public void readAttributeInvalid() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.getAttribute((Path)path, (String)"*", (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("*");
    }

    @Test
    public void readAttributeInvalid2() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.getAttribute((Path)path, (String)"isRegularFile,isDirectory", (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("isRegularFile,isDirectory");
    }

    @Test
    public void readAttributeInvalid3() {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Assertions.assertThatThrownBy(() -> Files.getAttribute((Path)path, (String)"isRegularFile", (LinkOption[])new LinkOption[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void getLastModifiedTime() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((Object)Files.getLastModifiedTime((Path)path, (LinkOption[])new LinkOption[0])).isNotNull();
    }

    @Test
    public void getLastModifiedTimeNoSuchFileException() {
        Path path = Paths.get((String)"/path/to/file", (String[])new String[0]);
        Assertions.assertThatThrownBy(() -> Files.getLastModifiedTime((Path)path, (LinkOption[])new LinkOption[0])).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void getLastModifiedTimeNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.getLastModifiedTime(null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void setLastModifiedTime() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.setLastModifiedTime((Path)path, null)).isInstanceOf(NotImplementedException.class);
    }

    @Test
    public void setLastModifiedTimeNoSuchFileException() {
        Path path = Paths.get((String)"/path/to/file", (String[])new String[0]);
        Assertions.assertThatThrownBy(() -> Files.setLastModifiedTime((Path)path, null)).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void setLastModifiedTimeNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.setLastModifiedTime(null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void setLastModifiedTimeNull2() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> Files.setLastModifiedTime((Path)path, null)).isInstanceOf(NotImplementedException.class);
    }

    @Test
    public void size() throws java.io.IOException {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((long)Files.size((Path)path)).isEqualTo(0L);
        Path sourceFile = this.newTempDir().resolve("file.txt");
        OutputStream stream = Files.newOutputStream((Path)sourceFile, (OpenOption[])new OpenOption[0]);
        stream.write(97);
        stream.close();
        AssertionsForClassTypes.assertThat((long)Files.size((Path)sourceFile)).isEqualTo(1L);
    }

    @Test
    public void sizeNoSuchFileException() {
        Path path = Paths.get((String)"/path/to/file", (String[])new String[0]);
        Assertions.assertThatThrownBy(() -> Files.size((Path)path)).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void sizeNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.size(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void exists() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)path, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)this.newTempDir(), (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)Paths.get((String)"/some/path/here", (String[])new String[0]), (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test
    public void existsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.exists(null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void notExists() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.notExists((Path)path, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.notExists((Path)this.newTempDir(), (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.notExists((Path)Paths.get((String)"/some/path/here", (String[])new String[0]), (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.notExists((Path)this.newTempDir().resolve("some.text"), (LinkOption[])new LinkOption[0])).isTrue();
    }

    @Test
    public void notExistsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.notExists(null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void isSameFile() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.isSameFile((Path)path, (Path)Paths.get((String)path.toString(), (String[])new String[0]))).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isSameFile((Path)path, (Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]))).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isSameFile((Path)this.newTempDir(), (Path)this.newTempDir())).isFalse();
        Path dir = this.newTempDir();
        AssertionsForClassTypes.assertThat((boolean)Files.isSameFile((Path)dir, (Path)Paths.get((String)dir.toString(), (String[])new String[0]))).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isSameFile((Path)Paths.get((String)"/path/to/some/place", (String[])new String[0]), (Path)Paths.get((String)"/path/to/some/place", (String[])new String[0]))).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isSameFile((Path)Paths.get((String)"/path/to/some/place", (String[])new String[0]), (Path)Paths.get((String)"/path/to/some/place/a", (String[])new String[0]))).isFalse();
    }

    @Test
    public void isSameFileNull1() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isSameFile((Path)path, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path2' should be not null!");
    }

    @Test
    public void isSameFileNull2() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isSameFile(null, (Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void isSameFileNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isSameFile(null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void isHidden() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)path)).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)this.newTempDir())).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test
    public void isHiddenNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isHidden(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void isReadable() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.isReadable((Path)path)).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isReadable((Path)this.newTempDir())).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isReadable((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test
    public void isReadableNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isReadable(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void isWritable() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.isWritable((Path)path)).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isWritable((Path)this.newTempDir())).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isWritable((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test
    public void isWritableNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isWritable(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void isExecutable() {
        Assume.assumeFalse((boolean)SimpleFileSystemProvider.OSType.currentOS().equals((Object)SimpleFileSystemProvider.OSType.WINDOWS));
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.isExecutable((Path)path)).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isExecutable((Path)this.newTempDir())).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isExecutable((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test
    public void isExecutableNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isExecutable(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void isSymbolicLink() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.isSymbolicLink((Path)path)).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isSymbolicLink((Path)this.newTempDir())).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isSymbolicLink((Path)Paths.get((String)"/some/file", (String[])new String[0]))).isFalse();
    }

    @Test
    public void isSymbolicLinkNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isSymbolicLink(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void isDirectory() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)this.newTempDir(), (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)Paths.get((String)"/some/file", (String[])new String[0]), (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test
    public void isDirectoryNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isDirectory(null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void isRegularFile() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isRegularFile((Path)this.newTempDir(), (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isRegularFile((Path)Paths.get((String)"/some/file", (String[])new String[0]), (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test
    public void isRegularFileNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.isRegularFile(null, (LinkOption[])new LinkOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    private static interface MyAttrs
    extends BasicFileAttributes {
    }

    private static interface MyAttrsView
    extends BasicFileAttributeView {
    }
}

