/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.data.Index;
import org.junit.Ignore;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.AbstractBaseTest;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class FileUtilityMethodsTest
extends AbstractBaseTest {
    @Test
    public void newBufferedReader() throws java.io.IOException {
        Path dir = this.newTempDir();
        try (OutputStream out = Files.newOutputStream((Path)dir.resolve("file.txt"), (OpenOption[])new OpenOption[0]);){
            Assertions.assertThat((Object)out).isNotNull();
            out.write("content".getBytes());
        }
        BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("file.txt"), (Charset)Charset.defaultCharset());
        Assertions.assertThat((Object)reader).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo("content");
        Assertions.assertThat((String)reader.readLine()).isNull();
        reader.close();
        try {
            reader.read();
            Assertions.fail((String)"can't read closed stream");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void newBufferedReaderNoSuchFileException() {
        Assertions.assertThatThrownBy(() -> Files.newBufferedReader((Path)Paths.get((String)"/some/file/here", (String[])new String[0]), (Charset)Charset.defaultCharset())).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void newBufferedReaderNoSuchFileException2() {
        Assertions.assertThatThrownBy(() -> Files.newBufferedReader((Path)this.newTempDir(), (Charset)Charset.defaultCharset())).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void newBufferedReaderNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newBufferedReader(null, (Charset)Charset.defaultCharset())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void newBufferedReaderNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newBufferedReader((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'cs' should be not null!");
    }

    @Test
    public void newBufferedReaderNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newBufferedReader(null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void newBufferedWriter() throws java.io.IOException {
        Path dir = this.newTempDir();
        try (BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            Assertions.assertThat((Object)writer).isNotNull();
            writer.write("content");
        }
        var3_3 = null;
        try (BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset());){
            Assertions.assertThat((Object)reader).isNotNull();
            ((AbstractStringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo("content");
            Assertions.assertThat((String)reader.readLine()).isNull();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        Files.newBufferedWriter((Path)Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
    }

    @Test
    public void newBufferedWriterNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newBufferedWriter(null, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void newBufferedWriterNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newBufferedWriter((Path)this.newTempDir().resolve("some"), null, (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'cs' should be not null!");
    }

    @Test
    public void newBufferedWriterNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.newBufferedWriter(null, null, (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void copyIn2Path() throws java.io.IOException {
        Path dir = this.newTempDir();
        try (BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            Assertions.assertThat((Object)writer).isNotNull();
            writer.write("content");
        }
        var3_3 = null;
        try (InputStream is = Files.newInputStream((Path)dir.resolve("myfile.txt"), (OpenOption[])new OpenOption[0]);){
            Files.copy((InputStream)is, (Path)dir.resolve("my_new_file.txt"), (CopyOption[])new CopyOption[0]);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        var3_3 = null;
        try (BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset());){
            Assertions.assertThat((Object)reader).isNotNull();
            ((AbstractStringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo("content");
            Assertions.assertThat((String)reader.readLine()).isNull();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void copyIn2PathReplaceExisting() throws java.io.IOException {
        Path dir = this.newTempDir();
        try (BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            Assertions.assertThat((Object)writer).isNotNull();
            writer.write("content");
        }
        var3_3 = null;
        try (BufferedWriter writer2 = Files.newBufferedWriter((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            Assertions.assertThat((Object)writer2).isNotNull();
            writer2.write("empty_content");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        var3_3 = null;
        try (InputStream is = Files.newInputStream((Path)dir.resolve("myfile.txt"), (OpenOption[])new OpenOption[0]);){
            Files.copy((InputStream)is, (Path)dir.resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        var3_3 = null;
        try (BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset());){
            Assertions.assertThat((Object)reader).isNotNull();
            ((AbstractStringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo("content");
            Assertions.assertThat((String)reader.readLine()).isNull();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void copyIn2PathReplaceExistingNotExists() throws java.io.IOException {
        Path dir = this.newTempDir();
        try (BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            Assertions.assertThat((Object)writer).isNotNull();
            writer.write("content");
        }
        var3_3 = null;
        try (InputStream is = Files.newInputStream((Path)dir.resolve("myfile.txt"), (OpenOption[])new OpenOption[0]);){
            Files.copy((InputStream)is, (Path)dir.resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        var3_3 = null;
        try (BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset());){
            Assertions.assertThat((Object)reader).isNotNull();
            Assertions.assertThat((String)reader.readLine()).isEqualTo("content");
            Assertions.assertThat((String)reader.readLine()).isNull();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void copyIn2PathNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((InputStream)null, (Path)this.newTempDir().resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'in' should be not null!");
    }

    @Test
    public void copyIn2PathNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((InputStream)Files.newInputStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0]), null, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'target' should be not null!");
    }

    @Test
    public void copyIn2PathNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((InputStream)Files.newInputStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0]), (Path)this.newTempDir().resolve("my_new_file.txt"), null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'options' should be not null!");
    }

    @Test
    public void copyIn2PathNull4() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((InputStream)Files.newInputStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0]), (Path)this.newTempDir().resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{null})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'opt' should be not null!");
    }

    @Test
    public void copyIn2PathInvalidOption() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((InputStream)Files.newInputStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (OpenOption[])new OpenOption[0]), (Path)this.newTempDir().resolve("my_new_file.txt"), (CopyOption[])new CopyOption[]{LinkOption.NOFOLLOW_LINKS})).isInstanceOf(UnsupportedOperationException.class)).hasMessage("NOFOLLOW_LINKS not supported");
    }

    @Test
    public void copyPath2Out() throws java.io.IOException {
        Path dir = this.newTempDir();
        try (BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            Assertions.assertThat((Object)writer).isNotNull();
            writer.write("content");
        }
        var3_3 = null;
        try (OutputStream os = Files.newOutputStream((Path)dir.resolve("my_new_file.txt"), (OpenOption[])new OpenOption[0]);){
            Files.copy((Path)dir.resolve("myfile.txt"), (OutputStream)os);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        var3_3 = null;
        try (BufferedReader reader = Files.newBufferedReader((Path)dir.resolve("my_new_file.txt"), (Charset)Charset.defaultCharset());){
            Assertions.assertThat((Object)reader).isNotNull();
            ((AbstractStringAssert)Assertions.assertThat((String)reader.readLine()).isNotNull()).isEqualTo("content");
            Assertions.assertThat((String)reader.readLine()).isNull();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void copyPath2OutNotExists() {
        Assertions.assertThatThrownBy(() -> {
            try (OutputStream os = Files.newOutputStream((Path)this.newTempDir().resolve("my_new_file.txt"), (OpenOption[])new OpenOption[0]);){
                Files.copy((Path)this.newTempDir().resolve("myfile.txt"), (OutputStream)os);
            }
        }).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void copyPath2OutNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (OutputStream os = Files.newOutputStream((Path)this.newTempDir().resolve("my_new_file.txt"), (OpenOption[])new OpenOption[0]);){
                Files.copy(null, (OutputStream)os);
            }
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'source' should be not null!");
    }

    @Test
    public void copyPath2OutNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'out' should be not null!");
    }

    @Test
    public void copyPath2OutInvalidOption() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.copy(null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'source' should be not null!");
    }

    @Test
    public void readAllBytes() throws java.io.IOException {
        Path dir = this.newTempDir();
        try (BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            Assertions.assertThat((Object)writer).isNotNull();
            writer.write("content");
        }
        byte[] result = Files.readAllBytes((Path)dir.resolve("myfile.txt"));
        Assertions.assertThat((byte[])result).hasSize("content".getBytes().length).isEqualTo((Object)"content".getBytes());
    }

    @Test(expected=OutOfMemoryError.class)
    @Ignore
    public void readAllBytesOutOfMemory() throws java.io.IOException {
        Path file = this.newTempDir().resolve("file.big");
        RandomAccessFile f = new RandomAccessFile(file.toFile(), "rw");
        f.setLength(0x80000000L);
        f.close();
        Files.readAllBytes((Path)file);
    }

    @Test
    public void readAllBytesFileNotExists() {
        Assertions.assertThatThrownBy(() -> Files.readAllBytes((Path)this.newTempDir().resolve("file.big"))).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void readAllBytesDir() {
        Assertions.assertThatThrownBy(() -> Files.readAllBytes((Path)this.newTempDir())).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void readAllBytesNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAllBytes(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAllLines() throws java.io.IOException {
        Path dir = this.newTempDir();
        BufferedWriter writer = Files.newBufferedWriter((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer).isNotNull();
        writer.write("content");
        writer.close();
        List result = Files.readAllLines((Path)dir.resolve("myfile.txt"), (Charset)Charset.defaultCharset());
        ((ListAssert)Assertions.assertThat((List)result).hasSize(1)).contains((Object)"content", Index.atIndex((int)0));
        BufferedWriter writer2 = Files.newBufferedWriter((Path)dir.resolve("myfile2.txt"), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((Object)writer2).isNotNull();
        writer2.write("content\nnewFile\nline");
        writer2.close();
        List result2 = Files.readAllLines((Path)dir.resolve("myfile2.txt"), (Charset)Charset.defaultCharset());
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)result2).hasSize(3)).contains((Object)"content", Index.atIndex((int)0))).contains((Object)"newFile", Index.atIndex((int)1))).contains((Object)"line", Index.atIndex((int)2));
    }

    @Test
    public void readAllLinesFileNotExists() {
        Assertions.assertThatThrownBy(() -> Files.readAllLines((Path)this.newTempDir().resolve("file.big"), (Charset)Charset.defaultCharset())).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void readAllLinesDir() {
        Assertions.assertThatThrownBy(() -> Files.readAllLines((Path)this.newTempDir(), (Charset)Charset.defaultCharset())).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void readAllLinesNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAllLines(null, (Charset)Charset.defaultCharset())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void readAllLinesNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAllLines((Path)Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]), null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'cs' should be not null!");
    }

    @Test
    public void readAllLinesNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.readAllLines(null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void write() {
        Path dir = this.newTempDir();
        Path file = dir.resolve("file.txt");
        Files.write((Path)file, (byte[])"content".getBytes(), (OpenOption[])new OpenOption[0]);
        Assertions.assertThat((byte[])Files.readAllBytes((Path)file)).hasSize("content".getBytes().length).isEqualTo((Object)"content".getBytes());
    }

    @Test
    public void writeDir() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.write((Path)this.newTempDir(), (byte[])"content".getBytes(), (OpenOption[])new OpenOption[0])).isInstanceOf(IOException.class)).hasMessage("Could not open output stream.");
    }

    @Test
    public void writeNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.write((Path)this.newTempDir().resolve("file.txt"), null, (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'bytes' should be not null!");
    }

    @Test
    public void writeNull2() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.write(null, (byte[])"".getBytes(), (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void writeNull3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.write(null, null, (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void writeLines() {
        Path dir = this.newTempDir();
        List<String> content = Arrays.asList("some", "value");
        Files.write((Path)dir.resolve("file.txt"), content, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
        List result = Files.readAllLines((Path)dir.resolve("file.txt"), (Charset)Charset.defaultCharset());
        ((ListAssert)((ListAssert)Assertions.assertThat((List)result).hasSize(2)).contains((Object)"some", Index.atIndex((int)0))).contains((Object)"value", Index.atIndex((int)1));
    }

    @Test
    public void writeLinesDir() {
        List<String> content = Arrays.asList("some", "value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.write((Path)this.newTempDir(), (Iterable)content, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0])).isInstanceOf(IOException.class)).hasMessage("Could not open output stream.");
    }

    @Test
    public void writeLinesNull1() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.write((Path)this.newTempDir().resolve("file.txt"), null, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'lines' should be not null!");
    }

    @Test
    public void writeLinesNull2() {
        ArrayList content = new ArrayList();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.write(null, (Iterable)content, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }

    @Test
    public void writeLinesNull4() {
        ArrayList content = new ArrayList();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.write((Path)this.newTempDir().resolve("file.txt"), (Iterable)content, null, (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'cs' should be not null!");
    }

    @Test
    public void writeLinesNull5() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Files.write(null, null, (OpenOption[])new OpenOption[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'path' should be not null!");
    }
}

