/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileStore;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileSystem;

public class SimpleFileSystemProviderWindowsTest {
    final File[] roots = new File[]{new File("c:\\"), new File("a:\\")};
    final SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider(this.roots, SimpleFileSystemProvider.OSType.WINDOWS);

    @Test
    public void simpleStateTest() {
        Assertions.assertThat((Object)this.fsProvider).isNotNull();
        Assertions.assertThat((String)this.fsProvider.getScheme()).isEqualTo((Object)"file");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fsProvider.getFileSystem(URI.create("file:///")), (String)"c:\\path\\to\\file.txt", (boolean)false);
        Assertions.assertThat((Object)path.getFileSystem()).isInstanceOf(SimpleWindowsFileSystem.class);
    }

    @Test
    public void checkGetFileStore() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fsProvider.getFileSystem(URI.create("file:///")), (String)"c:\\path\\to\\file.txt", (boolean)false);
        Assertions.assertThat((Object)this.fsProvider.getFileStore((Path)path)).isInstanceOf(SimpleWindowsFileStore.class);
        Assertions.assertThat((String)this.fsProvider.getFileStore((Path)path).name()).isEqualTo((Object)"c:\\");
    }
}

