/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.fest.assertions.api.MapAssert;
import org.junit.Test;
import org.uberfire.java.nio.base.BasicFileAttributesImpl;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.base.NotImplementedException;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class SimpleFileSystemProviderAttrsRelatedTest {
    @Test
    public void checkIsHidden() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((boolean)fsProvider.isHidden((Path)path)).isFalse();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((boolean)fsProvider.isHidden((Path)path2)).isEqualTo(tempFile.isHidden());
    }

    @Test(expected=IllegalArgumentException.class)
    public void isHiddenNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.isHidden(null);
    }

    @Test
    public void checkAccess() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        try {
            fsProvider.checkAccess((Path)path, new AccessMode[]{AccessMode.WRITE});
            Assertions.fail((String)"can't have write access on non existent file");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fsProvider.checkAccess((Path)path, new AccessMode[]{AccessMode.READ});
            Assertions.fail((String)"can't have read access on non existent file");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fsProvider.checkAccess((Path)path, new AccessMode[]{AccessMode.EXECUTE});
            Assertions.fail((String)"can't have execute access on non existent file");
        }
        catch (Exception exception) {
            // empty catch block
        }
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path2 = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        try {
            fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.WRITE});
        }
        catch (Exception ex) {
            Assertions.fail((String)"write access should be ok");
        }
        tempFile.setWritable(false);
        try {
            fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.WRITE});
            Assertions.fail((String)"can't have write access on file");
        }
        catch (Exception ex) {
            // empty catch block
        }
        tempFile.setWritable(true);
        try {
            fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.READ});
        }
        catch (Exception ex) {
            Assertions.fail((String)"read access should be ok");
        }
        tempFile.setReadable(false);
        if (SimpleFileSystemProvider.OSType.currentOS().equals((Object)SimpleFileSystemProvider.OSType.UNIX_LIKE)) {
            try {
                fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.READ});
                Assertions.fail((String)"can't have read access on file");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        tempFile.setReadable(true);
        if (SimpleFileSystemProvider.OSType.currentOS().equals((Object)SimpleFileSystemProvider.OSType.UNIX_LIKE)) {
            try {
                fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.EXECUTE});
                Assertions.fail((String)"can't have execute access on file");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        tempFile.setExecutable(true);
        try {
            fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.EXECUTE});
        }
        catch (Exception ex) {
            Assertions.fail((String)"execute access should be ok");
        }
        try {
            fsProvider.checkAccess((Path)path2, new AccessMode[]{AccessMode.READ, AccessMode.WRITE, AccessMode.EXECUTE});
        }
        catch (Exception ex) {
            Assertions.fail((String)"all access should be ok");
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkAccessNull1() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.checkAccess(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkAccessNull2() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.checkAccess((Path)path, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkAccessNull3() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.checkAccess(null, new AccessMode[]{AccessMode.READ});
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkAccessNull4() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.checkAccess((Path)path, new AccessMode[]{null, AccessMode.READ});
    }

    @Test
    public void checkGetFileStore() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((Object)fsProvider.getFileStore((Path)path)).isNotNull();
        ((IterableAssert)Assertions.assertThat((Iterable)fsProvider.getFileSystem(path.toUri()).getFileStores()).isNotNull()).contains((Object[])new FileStore[]{fsProvider.getFileStore((Path)path)});
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileStoreNull() {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.getFileStore(null);
    }

    @Test
    public void checkGetFileAttributeViewGeneral() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        BasicFileAttributeView view = (BasicFileAttributeView)fsProvider.getFileAttributeView((Path)path, BasicFileAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((Object)view).isNotNull();
        Assertions.assertThat((Object)view.readAttributes()).isNotNull();
        Assertions.assertThat((boolean)view.readAttributes().isRegularFile()).isTrue();
        Assertions.assertThat((boolean)view.readAttributes().isDirectory()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isOther()).isFalse();
        Assertions.assertThat((long)view.readAttributes().size()).isEqualTo(0L);
    }

    @Test
    public void checkGetFileAttributeViewBasic() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        BasicFileAttributeView view = (BasicFileAttributeView)fsProvider.getFileAttributeView((Path)path, BasicFileAttributeView.class, new LinkOption[0]);
        Assertions.assertThat((Object)view).isNotNull();
        Assertions.assertThat((Object)view.readAttributes()).isNotNull();
        Assertions.assertThat((boolean)view.readAttributes().isRegularFile()).isTrue();
        Assertions.assertThat((boolean)view.readAttributes().isDirectory()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)view.readAttributes().isOther()).isFalse();
        Assertions.assertThat((long)view.readAttributes().size()).isEqualTo(0L);
    }

    @Test
    public void getFileAttributeViewInvalidView() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((Object)fsProvider.getFileAttributeView((Path)path, MyAttrsView.class, new LinkOption[0])).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileAttributeViewNull1() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.getFileAttributeView(null, MyAttrsView.class, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileAttributeViewNull2() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.getFileAttributeView((Path)path, null, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileAttributeViewNull3() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.getFileAttributeView(null, null, new LinkOption[0]);
    }

    @Test
    public void checkReadAttributesGeneral() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        BasicFileAttributesImpl attrs = (BasicFileAttributesImpl)fsProvider.readAttributes((Path)path, BasicFileAttributesImpl.class, new LinkOption[0]);
        Assertions.assertThat((Object)attrs).isNotNull();
        Assertions.assertThat((boolean)attrs.isRegularFile()).isTrue();
        Assertions.assertThat((boolean)attrs.isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)attrs.isOther()).isFalse();
        Assertions.assertThat((long)attrs.size()).isEqualTo(0L);
    }

    @Test
    public void checkReadAttributesBasic() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        BasicFileAttributes attrs = fsProvider.readAttributes((Path)path, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertThat((Object)attrs).isNotNull();
        Assertions.assertThat((boolean)attrs.isRegularFile()).isTrue();
        Assertions.assertThat((boolean)attrs.isDirectory()).isFalse();
        Assertions.assertThat((boolean)attrs.isSymbolicLink()).isFalse();
        Assertions.assertThat((boolean)attrs.isOther()).isFalse();
        Assertions.assertThat((long)attrs.size()).isEqualTo(0L);
    }

    @Test(expected=NoSuchFileException.class)
    public void readAttributesNonExistentFile() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.readAttributes((Path)path, BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test
    public void readAttributesInvalid() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        Assertions.assertThat((Object)fsProvider.readAttributes((Path)path, MyAttrs.class, new LinkOption[0])).isNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesNull1() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.readAttributes(null, MyAttrs.class, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesNull2() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (String)"/path/to/file.txt", (boolean)false);
        fsProvider.readAttributes((Path)path, (Class)null, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesNull3() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.readAttributes(null, (Class)null, new LinkOption[0]);
    }

    @Test
    public void checkReadAttributesMap() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:*", new LinkOption[0])).isNotNull()).hasSize(9);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "basic:someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "isRegularFile", new LinkOption[0])).isNotNull()).hasSize(1);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "isRegularFile,isDirectory", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "isRegularFile,isDirectory,someThing", new LinkOption[0])).isNotNull()).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)fsProvider.readAttributes((Path)path, "someThing", new LinkOption[0])).isNotNull()).hasSize(0);
        try {
            fsProvider.readAttributes((Path)path, ":someThing", new LinkOption[0]);
            Assertions.fail((String)"undefined view");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            fsProvider.readAttributes((Path)path, "advanced:isRegularFile", new LinkOption[0]);
            Assertions.fail((String)"undefined view");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesMapNull1() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.readAttributes(null, "*", new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesMapNull2() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.readAttributes((Path)path, (String)null, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesMapNull3() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.readAttributes(null, (String)null, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readAttributesMapEmpty() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.readAttributes((Path)path, "", new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeNull1() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.setAttribute((Path)path, null, null, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeNull2() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.setAttribute(null, "some", null, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeNull3() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        fsProvider.setAttribute(null, null, null, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeEmpty() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.setAttribute((Path)path, "", null, new LinkOption[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void setAttributeInvalidAttr() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.setAttribute((Path)path, "myattr", null, new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void setAttributeInvalidView() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.setAttribute((Path)path, "advanced:isRegularFile", null, new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAttributeInvalidView2() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.setAttribute((Path)path, ":isRegularFile", null, new LinkOption[0]);
    }

    @Test(expected=NotImplementedException.class)
    public void setAttributeNotImpl() throws IOException {
        SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider();
        File tempFile = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)fsProvider.getFileSystem(URI.create("file:///")), (File)tempFile);
        fsProvider.setAttribute((Path)path, "isRegularFile", null, new LinkOption[0]);
    }

    private static interface MyAttrs
    extends BasicFileAttributes {
    }

    private static interface MyAttrsView
    extends BasicFileAttributeView {
    }
}

