/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.net.URI;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;
import org.junit.Test;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileStore;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileSystem;

public class SimpleFileSystemProviderWindowsTest {
    final File[] roots = new File[]{new File("c:\\"), new File("a:\\")};
    final SimpleFileSystemProvider fsProvider = new SimpleFileSystemProvider(this.roots, SimpleFileSystemProvider.OSType.WINDOWS);

    @Test
    public void simpleStateTest() {
        Assertions.assertThat((Object)this.fsProvider).isNotNull();
        Assertions.assertThat((String)this.fsProvider.getScheme()).isNotEmpty().isEqualTo((Object)"file");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fsProvider.getFileSystem(URI.create("file:///")), (String)"c:\\path\\to\\file.txt", (boolean)false);
        ((ObjectAssert)Assertions.assertThat((Object)path.getFileSystem()).isNotNull()).isInstanceOf(SimpleWindowsFileSystem.class);
    }

    @Test
    public void checkGetFileStore() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fsProvider.getFileSystem(URI.create("file:///")), (String)"c:\\path\\to\\file.txt", (boolean)false);
        ((ObjectAssert)Assertions.assertThat((Object)this.fsProvider.getFileStore((Path)path)).isNotNull()).isInstanceOf(SimpleWindowsFileStore.class);
        ((StringAssert)Assertions.assertThat((String)this.fsProvider.getFileStore((Path)path).name()).isNotNull()).isEqualTo((Object)"c:\\");
    }
}

