/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.attribute.FileStoreAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.fs.file.SimpleUnixFileStore;

public class SimpleUnixFileStoreTest {
    @Test
    public void simpleTests() {
        SimpleUnixFileStore fileStore = new SimpleUnixFileStore(null);
        ((StringAssert)Assertions.assertThat((String)fileStore.name()).isNotNull()).isEqualTo((Object)"/");
        Assertions.assertThat((String)fileStore.type()).isNull();
        Assertions.assertThat((boolean)fileStore.isReadOnly()).isFalse();
        Assertions.assertThat((long)fileStore.getTotalSpace()).isEqualTo(File.listRoots()[0].getTotalSpace());
        Assertions.assertThat((long)fileStore.getUsableSpace()).isEqualTo(File.listRoots()[0].getUsableSpace());
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(BasicFileAttributeView.class)).isTrue();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(MyFileAttributeView.class)).isFalse();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(MyAlsoInvalidFileAttributeView.class)).isFalse();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView("basic")).isTrue();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView("any")).isFalse();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(BasicFileAttributeView.class.getName())).isFalse();
        Assertions.assertThat((boolean)fileStore.supportsFileAttributeView(MyAlsoInvalidFileAttributeView.class.getName())).isFalse();
        Assertions.assertThat((Object)fileStore.getFileStoreAttributeView(FileStoreAttributeView.class)).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)fileStore.getAttribute("name")).isNotNull()).isEqualTo((Object)fileStore.name());
        ((ObjectAssert)Assertions.assertThat((Object)fileStore.getAttribute("totalSpace")).isNotNull()).isEqualTo((Object)fileStore.getTotalSpace());
        ((ObjectAssert)Assertions.assertThat((Object)fileStore.getAttribute("usableSpace")).isNotNull()).isEqualTo((Object)fileStore.getUsableSpace());
        ((ObjectAssert)Assertions.assertThat((Object)fileStore.getAttribute("readOnly")).isNotNull()).isEqualTo((Object)fileStore.isReadOnly());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getUnallocatedSpaceUnsupportedOp() {
        new SimpleUnixFileStore(null).getUnallocatedSpace();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getAttributeUnsupportedOp() {
        new SimpleUnixFileStore(null).getAttribute("someValueHere");
    }

    @Test(expected=IllegalArgumentException.class)
    public void supportsFileAttributeViewNull1() {
        new SimpleUnixFileStore(null).supportsFileAttributeView((Class)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void supportsFileAttributeViewNull2() {
        new SimpleUnixFileStore(null).supportsFileAttributeView((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void supportsFileAttributeViewEmpty() {
        new SimpleUnixFileStore(null).supportsFileAttributeView("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileStoreAttributeViewNull() {
        new SimpleUnixFileStore(null).getFileStoreAttributeView(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAttributeNull() {
        new SimpleUnixFileStore(null).getAttribute(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAttributeEmpty() {
        new SimpleUnixFileStore(null).getAttribute("");
    }

    private static class MyAlsoInvalidFileAttributeView
    implements BasicFileAttributeView {
        private MyAlsoInvalidFileAttributeView() {
        }

        public BasicFileAttributes readAttributes() throws IOException {
            return null;
        }

        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        }

        public String name() {
            return null;
        }
    }

    private static class MyFileAttributeView
    implements FileAttributeView {
        private MyFileAttributeView() {
        }

        public String name() {
            return null;
        }
    }
}

